"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiListGroupItem = exports.COLORS = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _icon = require("../icon");
var _tool_tip = require("../tool_tip");
var _inner_text = require("../inner_text");
var _list_group_item_extra_action = require("./list_group_item_extra_action");
var _services = require("../../services");
var _href_validator = require("../../services/security/href_validator");
var _external_link_icon = require("../link/external_link_icon");
var _list_group_item = require("./list_group_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["label", "isActive", "isDisabled", "href", "rel", "target", "external", "className", "css", "style", "iconType", "icon", "iconProps", "extraAction", "onClick", "size", "color", "showToolTip", "wrapText", "buttonRef", "toolTipText", "toolTipProps"],
  _excluded2 = ["iconType", "alwaysShow", "isDisabled"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var SIZES = exports.SIZES = ['xs', 's', 'm', 'l'];
var COLORS = exports.COLORS = ['primary', 'text', 'subdued'];
var EuiListGroupItem = exports.EuiListGroupItem = function EuiListGroupItem(_ref) {
  var label = _ref.label,
    _ref$isActive = _ref.isActive,
    isActive = _ref$isActive === void 0 ? false : _ref$isActive,
    _ref$isDisabled = _ref.isDisabled,
    _isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
    href = _ref.href,
    rel = _ref.rel,
    target = _ref.target,
    external = _ref.external,
    className = _ref.className,
    customCss = _ref.css,
    style = _ref.style,
    iconType = _ref.iconType,
    icon = _ref.icon,
    iconProps = _ref.iconProps,
    extraAction = _ref.extraAction,
    onClick = _ref.onClick,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'text' : _ref$color,
    _ref$showToolTip = _ref.showToolTip,
    showToolTip = _ref$showToolTip === void 0 ? false : _ref$showToolTip,
    wrapText = _ref.wrapText,
    buttonRef = _ref.buttonRef,
    toolTipText = _ref.toolTipText,
    toolTipProps = _ref.toolTipProps,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isClickable = !!(href || onClick);
  var isHrefValid = !href || (0, _href_validator.validateHref)(href);
  var isDisabled = _isDisabled || !isHrefValid;
  var euiTheme = (0, _services.useEuiTheme)();
  var iconStyles = (0, _list_group_item.euiListGroupItemIconStyles)(euiTheme);
  var cssIconStyles = [iconStyles.euiListGroupItem__icon, iconProps === null || iconProps === void 0 ? void 0 : iconProps.css];
  var iconNode;
  if (iconType) {
    iconNode = (0, _react2.jsx)(_icon.EuiIcon, (0, _extends2.default)({
      color: "inherit" // forces the icon to inherit its parent color
    }, iconProps, {
      type: iconType,
      className: (0, _classnames.default)('euiListGroupItem__icon', iconProps === null || iconProps === void 0 ? void 0 : iconProps.className),
      css: cssIconStyles
    }));
    if (icon) {
      console.warn('Both `iconType` and `icon` were passed to EuiListGroupItem but only one can exist. The `iconType` was used.');
    }
  } else if (icon) {
    iconNode = (0, _services.cloneElementWithCss)(icon, {
      css: cssIconStyles,
      className: (0, _classnames.default)('euiListGroupItem__icon', icon.props.className)
    });
  }
  var extraActionNode;
  if (extraAction) {
    var _iconType = extraAction.iconType,
      alwaysShow = extraAction.alwaysShow,
      actionIsDisabled = extraAction.isDisabled,
      _rest = (0, _objectWithoutProperties2.default)(extraAction, _excluded2);

    // EuiListGroupItemExtraActionProps extends EuiButtonIconPropsForButton
    // which doesn't have the color `subdued` so we need to assign a valid color
    // the most similar is `text` so we'll use that
    var extraActionColor = color === 'subdued' ? 'text' : color;
    extraActionNode = (0, _react2.jsx)(_list_group_item_extra_action.EuiListGroupItemExtraAction, (0, _extends2.default)({
      color: extraActionColor,
      iconType: _iconType,
      alwaysShow: alwaysShow
    }, _rest, {
      isDisabled: actionIsDisabled,
      parentIsDisabled: isDisabled
    }));
  }
  var labelStyles = (0, _list_group_item.euiListGroupItemLabelStyles)();
  var cssLabelStyles = [labelStyles.euiListGroupItem__label, wrapText ? labelStyles.wrapText : labelStyles.truncate];

  // Only add the label as the title attribute if it's possibly truncated
  // Also ensure the value of the title attribute is a string
  var _useInnerText = (0, _inner_text.useInnerText)(),
    _useInnerText2 = (0, _slicedToArray2.default)(_useInnerText, 2),
    ref = _useInnerText2[0],
    innerText = _useInnerText2[1];
  var shouldRenderTitle = !wrapText && !showToolTip;
  var labelContent = shouldRenderTitle ? (0, _react2.jsx)("span", {
    ref: ref,
    className: "euiListGroupItem__label",
    css: cssLabelStyles,
    title: typeof label === 'string' ? label : innerText
  }, label) : (0, _react2.jsx)("span", {
    className: "euiListGroupItem__label",
    css: cssLabelStyles
  }, label);

  // Handle the variety of interaction behavior
  var itemContent;
  var innerStyles = (0, _list_group_item.euiListGroupItemInnerStyles)(euiTheme);
  var cssInnerStyles = [innerStyles.euiListGroupItem__inner, innerStyles[size], !isDisabled && innerStyles[color], isActive && innerStyles.isActive, isDisabled && innerStyles.isDisabled, isClickable && !isDisabled && innerStyles.isClickable];
  if (href && !isDisabled) {
    itemContent = (0, _react2.jsx)("a", (0, _extends2.default)({
      className: "euiListGroupItem__button",
      css: cssInnerStyles,
      href: href,
      target: target,
      rel: (0, _services.getSecureRelForTarget)({
        href: href,
        rel: rel,
        target: target
      }),
      onClick: onClick
    }, rest), iconNode, labelContent, (0, _react2.jsx)(_external_link_icon.EuiExternalLinkIcon, {
      external: external,
      target: target
    }));
  } else if (href && isDisabled || onClick) {
    itemContent = (0, _react2.jsx)("button", (0, _extends2.default)({
      type: "button",
      className: "euiListGroupItem__button",
      css: cssInnerStyles,
      disabled: isDisabled,
      onClick: onClick,
      ref: buttonRef
    }, rest), iconNode, labelContent);
  } else {
    itemContent = (0, _react2.jsx)("span", (0, _extends2.default)({
      className: "euiListGroupItem__text",
      css: cssInnerStyles
    }, rest), iconNode, labelContent);
  }
  var styles = (0, _list_group_item.euiListGroupItemStyles)(euiTheme);
  var cssStyles = [styles.euiListGroupItem, !isDisabled && isActive && styles.colors.isActive[color], !isDisabled && isClickable && styles.colors.isClickable[color], styles[size], customCss];
  var classes = (0, _classnames.default)('euiListGroupItem', className);
  if (showToolTip) {
    var _toolTipProps$anchorP;
    var tooltipStyles = (0, _list_group_item.euiListGroupItemTooltipStyles)();
    var cssTooltipStyles = [tooltipStyles.euiListGroupItem__tooltip, toolTipProps === null || toolTipProps === void 0 || (_toolTipProps$anchorP = toolTipProps.anchorProps) === null || _toolTipProps$anchorP === void 0 ? void 0 : _toolTipProps$anchorP.css];
    var anchorClasses = (0, _classnames.default)('euiListGroupItem__tooltip', toolTipProps === null || toolTipProps === void 0 ? void 0 : toolTipProps.anchorClassName);
    var anchorPropsAndCss = _objectSpread(_objectSpread({}, toolTipProps === null || toolTipProps === void 0 ? void 0 : toolTipProps.anchorProps), {}, {
      css: cssTooltipStyles
    });
    itemContent = (0, _react2.jsx)("li", {
      className: classes,
      css: cssStyles,
      style: style
    }, (0, _react2.jsx)(_tool_tip.EuiToolTip, (0, _extends2.default)({
      content: toolTipText !== null && toolTipText !== void 0 ? toolTipText : label,
      position: "right",
      delay: "long"
    }, toolTipProps, {
      anchorClassName: anchorClasses,
      anchorProps: anchorPropsAndCss
    }), (0, _react2.jsx)(_react.default.Fragment, null, itemContent, extraActionNode)));
  } else {
    itemContent = (0, _react2.jsx)("li", {
      className: classes,
      css: cssStyles,
      style: style
    }, itemContent, extraActionNode);
  }
  return (0, _react2.jsx)(_react.Fragment, null, itemContent);
};