"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiListGroupItemExtraAction = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _button = require("../button");
var _services = require("../../services");
var _list_group_item_extra_action = require("./list_group_item_extra_action.styles");
var _react2 = require("@emotion/react");
var _excluded = ["iconType", "alwaysShow", "className", "isDisabled", "parentIsDisabled", "color"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiListGroupItemExtraAction = exports.EuiListGroupItemExtraAction = function EuiListGroupItemExtraAction(_ref) {
  var iconType = _ref.iconType,
    alwaysShow = _ref.alwaysShow,
    className = _ref.className,
    isDisabled = _ref.isDisabled,
    parentIsDisabled = _ref.parentIsDisabled,
    color = _ref.color,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var extraActionClasses = (0, _classnames.default)('euiListGroupItemExtraAction', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var extraActionStyles = (0, _list_group_item_extra_action.euiListGroupItemExtraActionStyles)(euiTheme);
  var cssExtraActionStyles = [extraActionStyles.euiListGroupItemExtraAction, alwaysShow && extraActionStyles.alwaysShow, !alwaysShow && !parentIsDisabled && extraActionStyles.hoverStyles];
  return (0, _react2.jsx)(_button.EuiButtonIcon, (0, _extends2.default)({
    color: color,
    className: extraActionClasses,
    css: cssExtraActionStyles,
    iconType: iconType,
    disabled: isDisabled || parentIsDisabled
  }, rest));
};