"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPinnableListGroup = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("../../i18n");
var _list_group = require("../list_group");
var _services = require("../../../services");
var _pinnable_list_group = require("./pinnable_list_group.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "listItems", "pinTitle", "unpinTitle", "onPinClick"],
  _excluded2 = ["pinned", "pinnable"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiPinnableListGroup = exports.EuiPinnableListGroup = function EuiPinnableListGroup(_ref) {
  var className = _ref.className,
    listItems = _ref.listItems,
    pinTitle = _ref.pinTitle,
    unpinTitle = _ref.unpinTitle,
    onPinClick = _ref.onPinClick,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiPinnableListGroup', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var itemExtraActionStyles = (0, _pinnable_list_group.euiPinnableListGroupItemExtraActionStyles)(euiTheme);
  var pinExtraAction = {
    iconType: 'pinFilled',
    iconSize: 's',
    css: itemExtraActionStyles.euiPinnableListGroup__itemExtraAction
  };
  var pinnedExtraAction = {
    iconType: 'pinFilled',
    iconSize: 's',
    css: [itemExtraActionStyles.euiPinnableListGroup__itemExtraAction, itemExtraActionStyles.pinned],
    alwaysShow: true
  };

  // Alter listItems object with extra props
  var getNewListItems = function getNewListItems(pinExtraActionLabel, pinnedExtraActionLabel) {
    return listItems.map(function (item) {
      var pinned = item.pinned,
        _item$pinnable = item.pinnable,
        pinnable = _item$pinnable === void 0 ? true : _item$pinnable,
        itemProps = (0, _objectWithoutProperties2.default)(item, _excluded2);
      // Make some declarations of props for the nav implementation
      itemProps.className = (0, _classnames.default)('euiPinnableListGroup__item', item.className);

      // Add the pinning action unless the item has it's own extra action
      if (pinnable && !itemProps.extraAction) {
        // Different displays for pinned vs unpinned
        if (pinned) {
          itemProps.extraAction = _objectSpread(_objectSpread({}, pinnedExtraAction), {}, {
            title: unpinTitle ? unpinTitle(item) : pinnedExtraActionLabel,
            'aria-label': unpinTitle ? unpinTitle(item) : pinnedExtraActionLabel
          });
        } else {
          itemProps.extraAction = _objectSpread(_objectSpread({}, pinExtraAction), {}, {
            title: pinTitle ? pinTitle(item) : pinExtraActionLabel,
            'aria-label': pinTitle ? pinTitle(item) : pinExtraActionLabel
          });
        }
        // Return the item on click
        itemProps.extraAction.onClick = function () {
          return onPinClick(item);
        };
      }
      return itemProps;
    });
  };
  return (0, _react2.jsx)(_i18n.EuiI18n, {
    tokens: ['euiPinnableListGroup.pinExtraActionLabel', 'euiPinnableListGroup.pinnedExtraActionLabel'],
    defaults: ['Pin item', 'Unpin item']
  }, function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
      pinExtraActionLabel = _ref3[0],
      pinnedExtraActionLabel = _ref3[1];
    var newListItems = getNewListItems(pinExtraActionLabel, pinnedExtraActionLabel);
    return (0, _react2.jsx)(_list_group.EuiListGroup, (0, _extends2.default)({
      className: classes,
      listItems: newListItems
    }, rest));
  });
};