"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiLoadingChart = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _loading_strings = require("./_loading_strings");
var _loading_chart = require("./loading_chart.styles");
var _react2 = require("@emotion/react");
var _excluded = ["size", "mono", "className", "aria-label"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var SIZES = exports.SIZES = ['m', 'l', 'xl'];
var EuiLoadingChart = exports.EuiLoadingChart = function EuiLoadingChart(_ref) {
  var _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$mono = _ref.mono,
    mono = _ref$mono === void 0 ? false : _ref$mono,
    className = _ref.className,
    ariaLabel = _ref['aria-label'],
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiLoadingChart', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_loading_chart.euiLoadingChartStyles);
  var cssStyles = [styles.euiLoadingChart, styles[size]];
  var barStyles = (0, _services.useEuiMemoizedStyles)(_loading_chart.euiLoadingChartBarStyles);
  var barCssStyles = [barStyles.euiLoadingChart__bar, mono ? barStyles.mono : barStyles.nonmono, barStyles[size]];
  var defaultAriaLabel = (0, _loading_strings.useLoadingAriaLabel)();
  return (0, _react2.jsx)("span", (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    role: "progressbar",
    "aria-label": ariaLabel || defaultAriaLabel
  }, rest), Array.from({
    length: _loading_chart.BARS_COUNT
  }, function (_, index) {
    return (0, _react2.jsx)("span", {
      key: index,
      css: barCssStyles
    });
  }));
};