"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiLoadingChartStyles = exports.euiLoadingChartBarStyles = exports.BARS_COUNT = void 0;
var _taggedTemplateLiteral2 = _interopRequireDefault(require("@babel/runtime/helpers/taggedTemplateLiteral"));
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _templateObject;
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var nonMonoColors = (0, _services.euiPaletteColorBlind)();
var _ref = process.env.NODE_ENV === "production" ? {
  name: "yovxj7-euiLoadingChart",
  styles: "overflow:hidden;display:inline-flex;label:euiLoadingChart;"
} : {
  name: "yovxj7-euiLoadingChart",
  styles: "overflow:hidden;display:inline-flex;label:euiLoadingChart;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiLoadingChartStyles = exports.euiLoadingChartStyles = function euiLoadingChartStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    euiLoadingChart: _ref,
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.base), " gap:", euiTheme.size.xxs, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.l), " gap:", euiTheme.size.xxs, ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.xl), " gap:", euiTheme.size.xs, ";;label:xl;")
  };
};
var BARS_COUNT = exports.BARS_COUNT = 4;
var euiLoadingChartBarStyles = exports.euiLoadingChartBarStyles = function euiLoadingChartBarStyles(_ref3) {
  var euiTheme = _ref3.euiTheme,
    colorMode = _ref3.colorMode;
  return {
    euiLoadingChart__bar: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', '100%'), " display:inline-block;", _global_styling.euiCanAnimate, "{animation:", barAnimation, " 1s infinite;", outputNthChildCss(function (index) {
      return "animation-delay: 0.".concat(index, "s;");
    }), ";}", _global_styling.euiCantAnimate, "{", outputNthChildCss(function (index) {
      return "transform: translateY(".concat(22 * index, "%);");
    }), ";};label:euiLoadingChart__bar;"),
    nonmono: /*#__PURE__*/(0, _react.css)(outputNthChildCss(function (index) {
      return "background-color: ".concat(nonMonoColors[index]);
    }), ";;label:nonmono;"),
    mono: /*#__PURE__*/(0, _react.css)(outputNthChildCss(function (index) {
      return "background-color: ".concat((0, _services.shadeOrTint)(euiTheme.colors.lightShade, index * 0.04, colorMode));
    }), ";;label:mono;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', euiTheme.size.xxs), " ", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.s), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.m), ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.base), ";;label:xl;")
  };
};

/**
 * Small utility helper for generating nth-child CSS for each bar
 */
var outputNthChildCss = function outputNthChildCss(css) {
  return Array.from({
    length: BARS_COUNT
  }, function (_, index) {
    return "\n  &:nth-child(".concat(index + 1, ") {\n    ").concat(css(index), "\n  }");
  }).join();
};
var barAnimation = (0, _react.keyframes)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n  0% {\n    transform: translateY(0);\n  }\n\n  50% {\n    transform: translateY(66%);\n  }\n\n  100% {\n    transform: translateY(0);\n  }\n"])));