"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiLoadingSpinner = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _loading_strings = require("./_loading_strings");
var _loading_spinner = require("./loading_spinner.styles");
var _react2 = require("@emotion/react");
var _excluded = ["size", "className", "aria-label", "color", "style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var SIZES = exports.SIZES = ['s', 'm', 'l', 'xl', 'xxl'];
var EuiLoadingSpinner = exports.EuiLoadingSpinner = function EuiLoadingSpinner(_ref) {
  var _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    className = _ref.className,
    ariaLabel = _ref['aria-label'],
    color = _ref.color,
    style = _ref.style,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiLoadingSpinner', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_loading_spinner.euiLoadingSpinnerStyles);
  var cssStyles = [styles.euiLoadingSpinner, styles[size]];
  var euiTheme = (0, _services.useEuiTheme)();
  var customColorStyle = color ? _objectSpread(_objectSpread({}, style), {}, {
    borderColor: (0, _loading_spinner.euiSpinnerBorderColorsCSS)(euiTheme, color)
  }) : style;
  var defaultLabel = (0, _loading_strings.useLoadingAriaLabel)();
  return (0, _react2.jsx)("span", (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    style: customColorStyle,
    role: "progressbar",
    "aria-label": ariaLabel || defaultLabel
  }, rest));
};