"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMark = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _mark = require("./mark.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "hasScreenReaderHelpText"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiMark = exports.EuiMark = function EuiMark(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$hasScreenReaderH = _ref.hasScreenReaderHelpText,
    hasScreenReaderHelpText = _ref$hasScreenReaderH === void 0 ? true : _ref$hasScreenReaderH,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiMark', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_mark.euiMarkStyles);
  var highlightStart = (0, _i18n.useEuiI18n)('euiMark.highlightStart', 'highlight start');
  var highlightEnd = (0, _i18n.useEuiI18n)('euiMark.highlightEnd', 'highlight end');
  var screenReaderStyles = (0, _react.useMemo)(function () {
    return (0, _mark.euiMarkScreenReaderStyles)(highlightStart, highlightEnd);
  }, [highlightStart, highlightEnd]);
  var cssStyles = [styles.euiMark, hasScreenReaderHelpText && screenReaderStyles.hasScreenReaderHelpText];
  return (0, _react2.jsx)("mark", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest), children);
};