"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMarkdownEditorToolbar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _button = require("../button");
var _i18n = require("../i18n");
var _tool_tip = require("../tool_tip");
var _markdown_modes = require("./markdown_modes");
var _markdown_context = require("./markdown_context");
var _markdown_editor_toolbar = require("./markdown_editor_toolbar.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var boldItalicButtons = [{
  id: 'mdBold',
  label: 'Bold',
  name: 'strong',
  iconType: 'editorBold'
}, {
  id: 'mdItalic',
  label: 'Italic',
  name: 'emphasis',
  iconType: 'editorItalic'
}];
var listButtons = [{
  id: 'mdUl',
  label: 'Unordered list',
  name: 'ul',
  iconType: 'editorUnorderedList'
}, {
  id: 'mdOl',
  label: 'Ordered list',
  name: 'ol',
  iconType: 'editorOrderedList'
}, {
  id: 'mdTl',
  label: 'Task list',
  name: 'tl',
  iconType: 'editorChecklist'
}];
var quoteCodeLinkButtons = [{
  id: 'mdQuote',
  label: 'Quote',
  name: 'quote',
  iconType: 'quote'
}, {
  id: 'mdCode',
  label: 'Code',
  name: 'inlineCode',
  iconType: 'editorCodeBlock'
}, {
  id: 'mdLink',
  label: 'Link',
  name: 'link',
  iconType: 'editorLink'
}];
var EuiMarkdownEditorToolbarButton = function EuiMarkdownEditorToolbarButton(_ref) {
  var selectedNode = _ref.selectedNode,
    handleMdButtonClick = _ref.handleMdButtonClick,
    isEditable = _ref.isEditable,
    isDisabled = _ref.isDisabled,
    id = _ref.id,
    nodeId = _ref.nodeId,
    label = _ref.label,
    icon = _ref.icon;
  var isSelected = selectedNode && selectedNode.type === nodeId;
  return (0, _react2.jsx)(_button.EuiButtonIcon, (0, _extends2.default)({
    color: "text"
  }, isSelected ? {
    style: {
      background: 'rgba(0, 0, 0, 0.15)'
    }
  } : null, {
    "data-test-subj": "euiMarkdownEditorToolbarButton".concat(isSelected ? ' pressed' : ''),
    onClick: function onClick() {
      return handleMdButtonClick(id);
    },
    iconType: icon,
    "aria-label": label,
    isDisabled: !isEditable || isDisabled
  }));
};
var EuiMarkdownEditorToolbar = exports.EuiMarkdownEditorToolbar = /*#__PURE__*/(0, _react.forwardRef)(function (_ref2, ref) {
  var markdownActions = _ref2.markdownActions,
    viewMode = _ref2.viewMode,
    onClickPreview = _ref2.onClickPreview,
    uiPlugins = _ref2.uiPlugins,
    selectedNode = _ref2.selectedNode;
  var _useContext = (0, _react.useContext)(_markdown_context.EuiMarkdownContext),
    openPluginEditor = _useContext.openPluginEditor,
    readOnly = _useContext.readOnly;
  var handleMdButtonClick = function handleMdButtonClick(mdButtonId) {
    var actionResult = markdownActions.do(mdButtonId);
    if (actionResult !== true) openPluginEditor(actionResult);
  };
  var isPreviewing = viewMode === _markdown_modes.MODE_VIEWING;
  var isEditable = !isPreviewing && !readOnly;
  var styles = (0, _services.useEuiMemoizedStyles)(_markdown_editor_toolbar.euiMarkdownEditorToolbarStyles);
  return (0, _react2.jsx)("div", {
    ref: ref,
    css: styles.euiMarkdownEditorToolbar,
    className: "euiMarkdownEditorToolbar",
    "data-test-subj": "euiMarkdownEditorToolbar"
  }, (0, _react2.jsx)("div", {
    css: styles.euiMarkdownEditorToolbar__buttons,
    className: "euiMarkdownEditorToolbar__buttons"
  }, boldItalicButtons.map(function (item) {
    return (0, _react2.jsx)(_tool_tip.EuiToolTip, {
      key: item.id,
      content: item.label,
      delay: "long"
    }, (0, _react2.jsx)(EuiMarkdownEditorToolbarButton, {
      selectedNode: selectedNode,
      handleMdButtonClick: handleMdButtonClick,
      isEditable: isEditable,
      id: item.id,
      nodeId: item.name,
      label: item.label,
      icon: item.iconType
    }));
  }), (0, _react2.jsx)("span", {
    css: styles.euiMarkdownEditorToolbar__divider,
    className: "euiMarkdownEditorToolbar__divider"
  }), listButtons.map(function (item) {
    return (0, _react2.jsx)(_tool_tip.EuiToolTip, {
      key: item.id,
      content: item.label,
      delay: "long"
    }, (0, _react2.jsx)(EuiMarkdownEditorToolbarButton, {
      selectedNode: selectedNode,
      handleMdButtonClick: handleMdButtonClick,
      isEditable: isEditable,
      id: item.id,
      nodeId: item.name,
      label: item.label,
      icon: item.iconType
    }));
  }), (0, _react2.jsx)("span", {
    css: styles.euiMarkdownEditorToolbar__divider,
    className: "euiMarkdownEditorToolbar__divider"
  }), quoteCodeLinkButtons.map(function (item) {
    return (0, _react2.jsx)(_tool_tip.EuiToolTip, {
      key: item.id,
      content: item.label,
      delay: "long"
    }, (0, _react2.jsx)(EuiMarkdownEditorToolbarButton, {
      selectedNode: selectedNode,
      handleMdButtonClick: handleMdButtonClick,
      isEditable: isEditable,
      id: item.id,
      nodeId: item.name,
      label: item.label,
      icon: item.iconType
    }));
  }), uiPlugins.length > 0 ? (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("span", {
    css: styles.euiMarkdownEditorToolbar__divider,
    className: "euiMarkdownEditorToolbar__divider"
  }), uiPlugins.map(function (_ref3) {
    var name = _ref3.name,
      button = _ref3.button;
    return (0, _react2.jsx)(_tool_tip.EuiToolTip, {
      key: name,
      content: button.label,
      delay: "long"
    }, (0, _react2.jsx)(EuiMarkdownEditorToolbarButton, {
      selectedNode: selectedNode,
      handleMdButtonClick: handleMdButtonClick,
      isEditable: isEditable,
      isDisabled: button.isDisabled,
      id: name,
      nodeId: name,
      label: button.label,
      icon: button.iconType
    }));
  })) : null), isPreviewing ? (0, _react2.jsx)(_button.EuiButtonEmpty, {
    "data-test-subj": "markdown_editor_edit_button",
    iconType: "editorCodeBlock",
    color: "text",
    size: "s",
    onClick: onClickPreview,
    isDisabled: readOnly
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiMarkdownEditorToolbar.editor",
    default: "Editor"
  })) : (0, _react2.jsx)(_button.EuiButtonEmpty, {
    "data-test-subj": "markdown_editor_preview_button",
    iconType: "eye",
    color: "text",
    size: "s",
    onClick: onClickPreview,
    isDisabled: readOnly
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiMarkdownEditorToolbar.previewMarkdown",
    default: "Preview"
  })));
});
EuiMarkdownEditorToolbar.displayName = 'EuiMarkdownEditorToolbar';