"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiMarkdownEditorToolbarStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _markdown_editor = require("./markdown_editor.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiMarkdownEditorToolbarStyles = exports.euiMarkdownEditorToolbarStyles = function euiMarkdownEditorToolbarStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiMarkdownEditorVar = (0, _markdown_editor.euiMarkdownEditorVariables)(euiThemeContext),
    barsBackgroundColor = _euiMarkdownEditorVar.barsBackgroundColor;
  return {
    euiMarkdownEditorToolbar: /*#__PURE__*/(0, _react.css)("display:flex;flex-wrap:wrap;padding:", euiTheme.size.xs, ";background-color:", barsBackgroundColor, ";border:", euiTheme.border.thin, ";", (0, _global_styling.logicalCSS)('border-bottom', 'none'), ";;label:euiMarkdownEditorToolbar;"),
    euiMarkdownEditorToolbar__buttons: /*#__PURE__*/(0, _react.css)("flex:1;display:flex;flex-wrap:wrap;align-items:center;column-gap:", euiTheme.size.xs, ";;label:euiMarkdownEditorToolbar__buttons;"),
    euiMarkdownEditorToolbar__divider: /*#__PURE__*/(0, _react.css)("display:block;", (0, _global_styling.logicalCSS)('height', euiTheme.size.l), " ", (0, _global_styling.logicalCSS)('margin-left', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('padding-right', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('border-left', "".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.border.color)), ";;label:euiMarkdownEditorToolbar__divider;")
  };
};