"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMarkdownFormat = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _unified = _interopRequireDefault(require("unified"));
var _classnames = _interopRequireDefault(require("classnames"));
var _text = require("../text/text");
var _text_color = require("../text/text_color");
var _services = require("../../services");
var _markdown_format = require("./markdown_format.styles");
var _markdown_default_plugins = require("./plugins/markdown_default_plugins");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "parsingPluginList", "processingPluginList", "textSize", "color"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiMarkdownFormat = exports.EuiMarkdownFormat = function EuiMarkdownFormat(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$parsingPluginLis = _ref.parsingPluginList,
    parsingPluginList = _ref$parsingPluginLis === void 0 ? _markdown_default_plugins.defaultParsingPlugins : _ref$parsingPluginLis,
    _ref$processingPlugin = _ref.processingPluginList,
    processingPluginList = _ref$processingPlugin === void 0 ? _markdown_default_plugins.defaultProcessingPlugins : _ref$processingPlugin,
    _ref$textSize = _ref.textSize,
    textSize = _ref$textSize === void 0 ? 'm' : _ref$textSize,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'default' : _ref$color,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var processor = (0, _react.useMemo)(function () {
    return (0, _unified.default)().use(parsingPluginList).use(processingPluginList);
  }, [parsingPluginList, processingPluginList]);
  var result = (0, _react.useMemo)(function () {
    try {
      var _ref2;
      var processed = processor.processSync(children);
      // `.result` is intentionally `unknown` (https://github.com/vfile/vfile/pull/53)
      // cast to something expected.
      return (_ref2 = processed.result) !== null && _ref2 !== void 0 ? _ref2 : processed.contents;
    } catch (e) {
      return children;
    }
  }, [children, processor]);
  var styles = (0, _services.useEuiMemoizedStyles)(_markdown_format.euiMarkdownFormatStyles);
  var cssStyles = [styles.euiMarkdownFormat, styles[textSize], (0, _text_color._isNamedColor)(color) ? styles.colors[color] : styles.colors.custom];
  var classes = (0, _classnames.default)('euiMarkdownFormat', className);
  return (0, _react2.jsx)(_text.EuiText, (0, _extends2.default)({
    size: textSize,
    css: cssStyles,
    className: classes,
    color: color
  }, rest), result);
};