"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultEuiMarkdownParsingPlugins = exports.defaultParsingPlugins = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _remarkParseNoTrim = _interopRequireDefault(require("remark-parse-no-trim"));
var _remarkEmoji = _interopRequireDefault(require("remark-emoji"));
var _remarkBreaks = _interopRequireDefault(require("remark-breaks"));
var _remark_prismjs = _interopRequireDefault(require("../remark/remark_prismjs"));
var MarkdownTooltip = _interopRequireWildcard(require("../markdown_tooltip"));
var MarkdownCheckbox = _interopRequireWildcard(require("../markdown_checkbox"));
var _markdown_link_validator = require("../markdown_link_validator");
var _excluded = ["exclude"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Importing seemingly unused types from `unified` because the definitions
// are exported for two versions of TypeScript (3.4, 4.0) and implicit
// imports during eui.d.ts generation default to the incorrect version (3.4).
// Explicit imports here resolve the version mismatch.
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var DEFAULT_PARSING_PLUGINS = {
  emoji: [_remarkEmoji.default, {
    emoticon: false
  }],
  lineBreaks: [_remarkBreaks.default, {}],
  linkValidator: [_markdown_link_validator.euiMarkdownLinkValidator, _markdown_link_validator.DEFAULT_OPTIONS],
  checkbox: [MarkdownCheckbox.parser, {}],
  tooltip: [MarkdownTooltip.parser, {}]
};
var getDefaultEuiMarkdownParsingPlugins = exports.getDefaultEuiMarkdownParsingPlugins = function getDefaultEuiMarkdownParsingPlugins() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var exclude = _ref.exclude,
    parsingConfig = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var parsingPlugins = [[_remarkParseNoTrim.default, {}], [_remark_prismjs.default, {}]];
  Object.entries(DEFAULT_PARSING_PLUGINS).forEach(function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
      pluginName = _ref3[0],
      plugin = _ref3[1];
    // Check for plugin exclusions
    if (!(exclude !== null && exclude !== void 0 && exclude.includes(pluginName))) {
      // Check for plugin configuration overrides
      if (pluginName in parsingConfig) {
        parsingPlugins.push([plugin[0], parsingConfig[pluginName]]);
      } else {
        parsingPlugins.push(plugin);
      }
    }
  });
  return parsingPlugins;
};
var defaultParsingPlugins = exports.defaultParsingPlugins = getDefaultEuiMarkdownParsingPlugins();