"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _index = require("./index");
var _button = require("../button");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var Modal = function Modal() {
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isModalVisible = _useState2[0],
    setIsModalVisible = _useState2[1];
  var closeModal = function closeModal() {
    return setIsModalVisible(false);
  };
  var showModal = function showModal() {
    return setIsModalVisible(true);
  };
  var modalProps = {
    title: 'Do this thing',
    onClose: closeModal,
    children: _react.default
  };
  return (0, _react2.jsx)("div", null, (0, _react2.jsx)(_button.EuiButton, {
    onClick: showModal
  }, "Show confirm modal"), isModalVisible && (0, _react2.jsx)(_index.EuiModal, modalProps, (0, _react2.jsx)(_index.EuiModalHeader, null, (0, _react2.jsx)(_index.EuiModalHeaderTitle, null, "Title of modal")), (0, _react2.jsx)(_index.EuiModalBody, null, (0, _react2.jsx)("p", null, "This is a simple modal body")), (0, _react2.jsx)(_index.EuiModalFooter, null, (0, _react2.jsx)(_button.EuiButton, {
    onClick: closeModal,
    fill: true
  }, "Close"))));
};
beforeEach(function () {
  cy.mount((0, _react2.jsx)(Modal, null));
  cy.get('div.euiModal').should('not.exist');
  cy.get('button.euiButton').realClick();
  cy.get('div.euiModal').should('exist');
});
describe('EuiModal', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations when modal is open', function () {
      cy.checkAxe();
    });
    it('has zero violations when modal is closed', function () {
      cy.get('div.euiModalFooter button.euiButton').click();
      cy.get('div.euiModal').should('not.exist');
      cy.checkAxe();
    });
  });
});