"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiModal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _utils = require("../../utils");
var _button = require("../button");
var _focus_trap = require("../focus_trap");
var _overlay_mask = require("../overlay_mask");
var _i18n = require("../i18n");
var _modal = require("./modal.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "children", "initialFocus", "onClose", "maxWidth", "role", "style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiModal = exports.EuiModal = function EuiModal(_ref) {
  var className = _ref.className,
    children = _ref.children,
    initialFocus = _ref.initialFocus,
    onClose = _ref.onClose,
    _ref$maxWidth = _ref.maxWidth,
    maxWidth = _ref$maxWidth === void 0 ? true : _ref$maxWidth,
    _ref$role = _ref.role,
    role = _ref$role === void 0 ? 'dialog' : _ref$role,
    style = _ref.style,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var onKeyDown = function onKeyDown(event) {
    if (event.key === _services.keys.ESCAPE) {
      if ((0, _utils.isDOMNode)(event.target) && event.currentTarget.contains(event.target)) {
        event.preventDefault();
        event.stopPropagation();
        onClose(event);
      }
    }
  };
  var newStyle = style;
  if (typeof maxWidth !== 'boolean') {
    newStyle = _objectSpread(_objectSpread({}, newStyle), {}, {
      maxInlineSize: maxWidth
    });
  }
  var classes = (0, _classnames.default)('euiModal', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _modal.euiModalStyles)(euiTheme);
  var cssStyles = [styles.euiModal, maxWidth === true && styles.defaultMaxWidth];
  var cssCloseIconStyles = [styles.euiModal__closeIcon];
  return (0, _react2.jsx)(_overlay_mask.EuiOverlayMask, null, (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
    initialFocus: initialFocus,
    scrollLock: true,
    preventScrollOnFocus: true
  }, (0, _react2.jsx)("div", (0, _extends2.default)({
    css: cssStyles,
    className: classes,
    onKeyDown: onKeyDown,
    tabIndex: 0,
    style: newStyle,
    role: role,
    "aria-modal": true
  }, rest), (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiModal.closeModal",
    default: "Closes this modal window"
  }, function (closeModal) {
    return (0, _react2.jsx)(_button.EuiButtonIcon, {
      iconType: "cross",
      onClick: onClose,
      css: cssCloseIconStyles,
      className: "euiModal__closeIcon",
      color: "text",
      "aria-label": closeModal
    });
  }), children)));
};