"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResizeObserver = exports.hasResizeObserver = exports.EuiResizeObserver = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("react");
var _observer = require("../observer");
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var hasResizeObserver = exports.hasResizeObserver = typeof window !== 'undefined' && typeof window.ResizeObserver !== 'undefined';
var EuiResizeObserver = exports.EuiResizeObserver = /*#__PURE__*/function (_EuiObserver) {
  function EuiResizeObserver() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiResizeObserver);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiResizeObserver, [].concat(args));
    (0, _defineProperty2.default)(_this, "name", 'EuiResizeObserver');
    (0, _defineProperty2.default)(_this, "state", {
      height: 0,
      width: 0
    });
    (0, _defineProperty2.default)(_this, "onResize", function (_ref) {
      var _ref2 = (0, _slicedToArray2.default)(_ref, 1),
        entry = _ref2[0];
      var _entry$borderBoxSize$ = entry.borderBoxSize[0],
        width = _entry$borderBoxSize$.inlineSize,
        height = _entry$borderBoxSize$.blockSize;

      // Check for actual resize event
      if (_this.state.height === height && _this.state.width === width) {
        return;
      }
      _this.props.onResize({
        height: height,
        width: width
      });
      _this.setState({
        height: height,
        width: width
      });
    });
    (0, _defineProperty2.default)(_this, "beginObserve", function () {
      // The superclass checks that childNode is not null before invoking
      // beginObserve()
      var childNode = _this.childNode;
      _this.observer = makeResizeObserver(childNode, _this.onResize);
    });
    return _this;
  }
  (0, _inherits2.default)(EuiResizeObserver, _EuiObserver);
  return (0, _createClass2.default)(EuiResizeObserver);
}(_observer.EuiObserver);
var makeResizeObserver = function makeResizeObserver(node, callback) {
  var observer;
  if (hasResizeObserver) {
    observer = new window.ResizeObserver(callback);
    observer.observe(node);
  }
  return observer;
};
var useResizeObserver = exports.useResizeObserver = function useResizeObserver(container, dimension) {
  var _useState = (0, _react.useState)({
      width: 0,
      height: 0
    }),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    size = _useState2[0],
    _setSize = _useState2[1];

  // _currentDimensions and _setSize are used to only store the
  // new state (and trigger a re-render) when the new dimensions actually differ
  var _currentDimensions = (0, _react.useRef)(size);
  var setSize = (0, _react.useCallback)(function (dimensions) {
    var doesWidthMatter = dimension !== 'height';
    var doesHeightMatter = dimension !== 'width';
    if (doesWidthMatter && _currentDimensions.current.width !== dimensions.width || doesHeightMatter && _currentDimensions.current.height !== dimensions.height) {
      _currentDimensions.current = dimensions;
      _setSize(dimensions);
    }
  }, [dimension]);
  (0, _react.useEffect)(function () {
    if (container != null) {
      var observer = makeResizeObserver(container, function (_ref3) {
        var _ref4 = (0, _slicedToArray2.default)(_ref3, 1),
          entry = _ref4[0];
        var _entry$borderBoxSize$2 = entry.borderBoxSize[0],
          inlineSize = _entry$borderBoxSize$2.inlineSize,
          blockSize = _entry$borderBoxSize$2.blockSize;
        setSize({
          width: inlineSize,
          height: blockSize
        });
      });
      return function () {
        return observer && observer.disconnect();
      };
    } else {
      setSize({
        width: 0,
        height: 0
      });
    }
  }, [container, setSize]);
  return size;
};