"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiOverlayMask = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _react2 = require("@emotion/react");
var _common = require("../common");
var _services = require("../../services");
var _portal = require("../portal");
var _overlay_mask = require("./overlay_mask.styles");
var _overlay_mask_body = require("./overlay_mask_body.styles");
var _excluded = ["className", "children", "headerZindexLocation", "maskRef"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiOverlayMask = exports.EuiOverlayMask = function EuiOverlayMask(_ref) {
  var className = _ref.className,
    children = _ref.children,
    _ref$headerZindexLoca = _ref.headerZindexLocation,
    headerZindexLocation = _ref$headerZindexLoca === void 0 ? 'above' : _ref$headerZindexLoca,
    maskRef = _ref.maskRef,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useState = (0, _react.useState)(null),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    overlayMaskNode = _useState2[0],
    setOverlayMaskNode = _useState2[1];
  var combinedMaskRef = (0, _services.useCombinedRefs)([setOverlayMaskNode, maskRef]);
  var styles = (0, _services.useEuiMemoizedStyles)(_overlay_mask.euiOverlayMaskStyles);
  var cssStyles = (0, _css.cx)([styles.euiOverlayMask, styles["".concat(headerZindexLocation, "Header")]]);
  (0, _react.useEffect)(function () {
    if (!overlayMaskNode) return;
    (0, _common.keysOf)(rest).forEach(function (key) {
      if (typeof rest[key] !== 'string') {
        throw new Error("Unhandled property type. EuiOverlayMask property ".concat(key, " is not a string."));
      }
      if (overlayMaskNode) {
        overlayMaskNode.setAttribute(key, rest[key]);
      }
    });
  }, [overlayMaskNode]); // eslint-disable-line react-hooks/exhaustive-deps

  // Note: Use `classList.add/remove` instead of setting the entire `className`
  // so as not to override any existing classes set by `EuiPortal`
  (0, _react.useEffect)(function () {
    if (overlayMaskNode) {
      overlayMaskNode.classList.add('euiOverlayMask', cssStyles);
      overlayMaskNode.dataset.relativeToHeader = headerZindexLocation;
      return function () {
        return overlayMaskNode.classList.remove(cssStyles);
      };
    }
  }, [overlayMaskNode, cssStyles, headerZindexLocation]);
  (0, _react.useEffect)(function () {
    if (className && overlayMaskNode) {
      var _overlayMaskNode$clas;
      var classNameArgs = className.split(' '); // The `classList` API doesn't support multiple classes in the same string
      (_overlayMaskNode$clas = overlayMaskNode.classList).add.apply(_overlayMaskNode$clas, (0, _toConsumableArray2.default)(classNameArgs));
      return function () {
        var _overlayMaskNode$clas2;
        return (_overlayMaskNode$clas2 = overlayMaskNode.classList).remove.apply(_overlayMaskNode$clas2, (0, _toConsumableArray2.default)(classNameArgs));
      };
    }
  }, [overlayMaskNode, className]);
  return (0, _react2.jsx)(_portal.EuiPortal, {
    portalRef: combinedMaskRef
  }, (0, _react2.jsx)(_react2.Global, {
    styles: _overlay_mask_body.euiOverlayMaskBodyStyles
  }), children);
};