"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _restrict_width = require("./_restrict_width");
var _global_styling = require("../../global_styling");
var _page = require("./page.styles");
var _services = require("../../services");
var _react2 = require("@emotion/react");
var _excluded = ["children", "restrictWidth", "className", "paddingSize", "grow", "direction"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiPage = exports.EuiPage = function EuiPage(_ref) {
  var children = _ref.children,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
    className = _ref.className,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'row' : _ref$direction,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  // Set max-width as a style prop
  var widthStyles = (0, _restrict_width.setStyleForRestrictedPageWidth)(restrictWidth, rest === null || rest === void 0 ? void 0 : rest.style);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _page.euiPageStyles)(euiTheme);
  var padding = (0, _global_styling.useEuiPaddingCSS)()[paddingSize];
  var stylesCSS = [styles.euiPage, styles[direction], grow && styles.grow, padding, restrictWidth && styles.restrictWidth];
  var classes = (0, _classnames.default)('euiPage', className);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: stylesCSS,
    className: classes
  }, rest, {
    style: widthStyles
  }), children);
};