"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPageBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _restrict_width = require("../_restrict_width");
var _panel = require("../../panel");
var _global_styling = require("../../../global_styling");
var _page_body = require("./page_body.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "restrictWidth", "className", "css", "component", "panelled", "panelProps", "paddingSize", "borderRadius"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiPageBody = exports.EuiPageBody = function EuiPageBody(_ref) {
  var children = _ref.children,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
    className = _ref.className,
    css = _ref.css,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'div' : _ref$component,
    panelled = _ref.panelled,
    panelProps = _ref.panelProps,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _ref$borderRadius = _ref.borderRadius,
    borderRadius = _ref$borderRadius === void 0 ? 'none' : _ref$borderRadius,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  // Set max-width as a style prop
  var widthStyles = (0, _restrict_width.setStyleForRestrictedPageWidth)(restrictWidth, rest === null || rest === void 0 ? void 0 : rest.style);

  // Shared
  var classes = (0, _classnames.default)('euiPageBody', className);
  var styles = (0, _page_body.euiPageBodyStyles)();
  var cssStyles = [styles.euiPageBody, restrictWidth && styles.restrictWidth];

  // Panelled
  var panelClasses = (0, _classnames.default)(classes, panelProps === null || panelProps === void 0 ? void 0 : panelProps.className);
  var panelCssStyles = [].concat(cssStyles, [panelProps === null || panelProps === void 0 ? void 0 : panelProps.css, css]);

  // Non-panelled
  var padding = (0, _global_styling.useEuiPaddingCSS)()[paddingSize];
  var componentCssStyles = [].concat(cssStyles, [padding, css]);
  return panelled ? (0, _react2.jsx)(_panel.EuiPanel, (0, _extends2.default)({
    borderRadius: borderRadius,
    paddingSize: paddingSize
  }, panelProps, rest, {
    className: panelClasses,
    css: panelCssStyles
  }), children) : (0, _react2.jsx)(Component, (0, _extends2.default)({}, rest, {
    className: classes,
    css: componentCssStyles,
    style: widthStyles
  }), children);
};