"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPageHeader = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _page_header_content = require("./page_header_content");
var _page_header = require("./page_header.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "restrictWidth", "paddingSize", "bottomBorder", "alignItems", "responsive", "children", "pageTitle", "pageTitleProps", "iconType", "iconProps", "tabs", "tabsProps", "breadcrumbs", "breadcrumbProps", "description", "rightSideItems", "rightSideGroupProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiPageHeader = exports.EuiPageHeader = function EuiPageHeader(_ref) {
  var className = _ref.className,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    bottomBorder = _ref.bottomBorder,
    alignItems = _ref.alignItems,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? true : _ref$responsive,
    children = _ref.children,
    pageTitle = _ref.pageTitle,
    pageTitleProps = _ref.pageTitleProps,
    iconType = _ref.iconType,
    iconProps = _ref.iconProps,
    tabs = _ref.tabs,
    tabsProps = _ref.tabsProps,
    breadcrumbs = _ref.breadcrumbs,
    breadcrumbProps = _ref.breadcrumbProps,
    description = _ref.description,
    rightSideItems = _ref.rightSideItems,
    rightSideGroupProps = _ref.rightSideGroupProps,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var useTheme = (0, _services.useEuiTheme)();
  var styles = (0, _page_header.euiPageHeaderStyles)(useTheme);
  var inlinePadding = (0, _global_styling.useEuiPaddingCSS)('horizontal');
  var cssStyles = [styles.euiPageHeader, inlinePadding[paddingSize], bottomBorder === 'extended' && styles.border];
  var classes = (0, _classnames.default)('euiPageHeader', className);
  var contentProps = {
    restrictWidth: restrictWidth,
    paddingSize: paddingSize,
    // Set the bottom to false to ensure the forced one doesn't render
    // when we'll be rendering it at this parent
    bottomBorder: bottomBorder === 'extended' ? false : bottomBorder,
    alignItems: alignItems,
    responsive: responsive,
    pageTitle: pageTitle,
    pageTitleProps: pageTitleProps,
    iconType: iconType,
    iconProps: iconProps,
    tabs: tabs,
    tabsProps: tabsProps,
    description: description,
    rightSideItems: rightSideItems,
    rightSideGroupProps: rightSideGroupProps,
    breadcrumbs: breadcrumbs,
    breadcrumbProps: breadcrumbProps
  };
  return (0, _react2.jsx)("header", (0, _extends2.default)({
    className: classes,
    css: cssStyles
  }, rest), (0, _react2.jsx)(_page_header_content.EuiPageHeaderContent, contentProps, children));
};