"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPageHeaderContent = exports.ALIGN_ITEMS = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _icon = require("../../icon");
var _tabs = require("../../tabs");
var _flex = require("../../flex");
var _spacer = require("../../spacer");
var _title = require("../../title");
var _text = require("../../text");
var _services = require("../../../services");
var _accessibility = require("../../accessibility");
var _breadcrumbs = require("../../breadcrumbs");
var _global_styling = require("../../../global_styling");
var _restrict_width = require("../_restrict_width");
var _page_header = require("./page_header.styles");
var _page_header_content = require("./page_header_content.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "pageTitle", "pageTitleProps", "iconType", "iconProps", "tabs", "tabsProps", "description", "breadcrumbs", "breadcrumbProps", "alignItems", "responsive", "rightSideItems", "rightSideGroupProps", "children", "restrictWidth", "paddingSize", "bottomBorder", "style"],
  _excluded2 = ["label"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var ALIGN_ITEMS = exports.ALIGN_ITEMS = ['top', 'bottom', 'center', 'stretch'];

// Gets all the tab props including the button or link props

/**
 * The left side can either be a title with optional description and/or icon;
 * Or a list of tabs,
 * Or a custom node
 */

var EuiPageHeaderContent = exports.EuiPageHeaderContent = function EuiPageHeaderContent(_ref) {
  var className = _ref.className,
    pageTitle = _ref.pageTitle,
    pageTitleProps = _ref.pageTitleProps,
    iconType = _ref.iconType,
    iconProps = _ref.iconProps,
    tabs = _ref.tabs,
    tabsProps = _ref.tabsProps,
    description = _ref.description,
    breadcrumbs = _ref.breadcrumbs,
    breadcrumbProps = _ref.breadcrumbProps,
    alignItems = _ref.alignItems,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? true : _ref$responsive,
    rightSideItems = _ref.rightSideItems,
    rightSideGroupProps = _ref.rightSideGroupProps,
    children = _ref.children,
    restrictWidth = _ref.restrictWidth,
    _ref$paddingSize = _ref.paddingSize,
    _paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _bottom_border = _ref.bottomBorder,
    style = _ref.style,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isResponsiveBreakpoint = (0, _services.useIsWithinBreakpoints)(['xs', 's'], !!responsive);
  var classes = (0, _classnames.default)('euiPageHeaderContent', className);
  var pageHeaderStyles = (0, _services.useEuiMemoizedStyles)(_page_header.euiPageHeaderStyles);
  var contentStyles = (0, _services.useEuiMemoizedStyles)(_page_header_content.euiPageHeaderContentStyles);
  var styles = (0, _restrict_width.setStyleForRestrictedPageWidth)(restrictWidth, style);
  var paddingSides = 'vertical';
  var paddingSize = _paddingSize;
  var bottomBorder = _bottom_border;
  var onlyChildren = !tabs && !pageTitle && !rightSideItems && !description && children;
  var onlyTabs = tabs && !pageTitle && !rightSideItems && !description && !children;
  var tabsAsTitle = tabs && !pageTitle;
  var tabsAtTheBottom = pageTitle && tabs;
  var borderWithoutPadding = (!paddingSize || paddingSize === 'none') && bottomBorder;
  if (onlyTabs) {
    paddingSize = 'none';
  } else if (tabsAsTitle) {
    paddingSides = 'bottom';
  } else if (tabsAtTheBottom) {
    paddingSides = 'top';
    bottomBorder = bottomBorder === false ? false : true;
  } else if (borderWithoutPadding) {
    paddingSides = 'bottom';
    paddingSize = 'l';
  }
  var blockPadding = (0, _global_styling.useEuiPaddingCSS)(paddingSides);
  var cssStyles = [contentStyles.euiPageHeaderContent, bottomBorder && pageHeaderStyles.border, blockPadding[paddingSize]];
  var childrenOnlyStyles = [contentStyles.childrenOnly.flex, contentStyles[alignItems || 'center'], isResponsiveBreakpoint && responsive && (responsive === 'reverse' ? contentStyles.childrenOnly.responsiveReverse : contentStyles.childrenOnly.responsive)];

  // Don't go any further if there's no other content than children
  if (onlyChildren) {
    return (0, _react2.jsx)("div", (0, _extends2.default)({
      css: cssStyles
    }, rest), (0, _react2.jsx)("div", {
      css: childrenOnlyStyles
    }, children));
  }
  var descriptionNode;
  if (description) {
    descriptionNode = (0, _react2.jsx)(_react.default.Fragment, null, (pageTitle || tabs) && (0, _react2.jsx)(_spacer.EuiSpacer, null), (0, _react2.jsx)(_text.EuiText, {
      grow: false
    }, (0, _react2.jsx)("p", null, description)));
  }
  var optionalBreadcrumbs = breadcrumbs ? (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_breadcrumbs.EuiBreadcrumbs, (0, _extends2.default)({
    breadcrumbs: breadcrumbs
  }, breadcrumbProps)), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "s"
  })) : undefined;
  var pageTitleNode;
  if (pageTitle) {
    var iconCssStyles = [contentStyles.euiPageHeaderContent__titleIcon, iconProps === null || iconProps === void 0 ? void 0 : iconProps.css];
    var icon = iconType ? (0, _react2.jsx)(_icon.EuiIcon, (0, _extends2.default)({
      size: "xl"
    }, iconProps, {
      css: iconCssStyles,
      type: iconType
    })) : undefined;
    pageTitleNode = (0, _react2.jsx)(_title.EuiTitle, (0, _extends2.default)({}, pageTitleProps, {
      size: "l"
    }), (0, _react2.jsx)("h1", null, icon, pageTitle));
  }
  var tabsNode;
  if (tabs) {
    var _tabs$find;
    var tabsSize = pageTitle ? 'l' : 'xl';
    var renderTabs = function renderTabs() {
      return tabs.map(function (tab, index) {
        var label = tab.label,
          tabRest = (0, _objectWithoutProperties2.default)(tab, _excluded2);
        return (0, _react2.jsx)(_tabs.EuiTab, (0, _extends2.default)({
          key: index
        }, tabRest), label);
      });
    };

    // When tabs exist without a pageTitle, we need to recreate an h1 based on the currently selected tab and visually hide it
    var screenReaderPageTitle = !pageTitle && (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("h1", null, (_tabs$find = tabs.find(function (obj) {
      return obj.isSelected === true;
    })) === null || _tabs$find === void 0 ? void 0 : _tabs$find.label));
    tabsNode = (0, _react2.jsx)(_react.default.Fragment, null, pageTitleNode && (0, _react2.jsx)(_spacer.EuiSpacer, null), screenReaderPageTitle, (0, _react2.jsx)(_tabs.EuiTabs, (0, _extends2.default)({}, tabsProps, {
      bottomBorder: false,
      size: tabsSize
    }), renderTabs()));
  }
  var childrenNode = children && (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_spacer.EuiSpacer, null), children);
  var bottomContentNode;
  if (tabsNode && pageTitleNode) {
    bottomContentNode = (0, _react2.jsx)("div", {
      className: "euiPageHeaderContent__bottom"
    }, pageTitleNode && tabsNode);
  }

  /**
   * The left side order depends on if a `pageTitle` was supplied.
   * If not, but there are `tabs`, then the tabs become the page title
   */
  var leftSideOrder;
  if (tabsNode && !pageTitleNode) {
    leftSideOrder = (0, _react2.jsx)(_react.default.Fragment, null, tabsNode, descriptionNode, childrenNode);
  } else {
    leftSideOrder = (0, _react2.jsx)(_react.default.Fragment, null, pageTitleNode, descriptionNode, childrenNode);
  }
  var leftSideFlexItem = (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: 2,
    css: contentStyles.euiPageHeaderContent__leftSideItems
  }, leftSideOrder);
  var rightSideFlexItem;
  if (rightSideItems && rightSideItems.length) {
    var itemsToRender = isResponsiveBreakpoint ? rightSideItems : (0, _toConsumableArray2.default)(rightSideItems).reverse();
    var rightSideFlexItems = itemsToRender.map(function (item, index) {
      return (0, _react2.jsx)(_flex.EuiFlexItem, {
        key: index,
        grow: false,
        css: contentStyles.euiPageHeaderContent__rightSideItem
      }, item);
    });
    var _cssStyles = [contentStyles.euiPageHeaderContent__rightSideItems, rightSideGroupProps === null || rightSideGroupProps === void 0 ? void 0 : rightSideGroupProps.css];
    rightSideFlexItem = (0, _react2.jsx)(_flex.EuiFlexGroup, (0, _extends2.default)({
      gutterSize: "l",
      responsive: false,
      wrap: true
    }, rightSideGroupProps, {
      css: _cssStyles
    }), rightSideFlexItems);
  }
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    style: styles
  }, rest), optionalBreadcrumbs, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    responsive: !!responsive,
    css: contentStyles.euiPageHeaderContent__top,
    className: "euiPageHeaderContent__top",
    alignItems: alignItems === 'bottom' ? 'flexEnd' : alignItems === 'top' ? 'flexStart' : alignItems,
    gutterSize: "l",
    wrap: true
  }, isResponsiveBreakpoint && responsive === 'reverse' ? (0, _react2.jsx)(_react.default.Fragment, null, rightSideFlexItem, leftSideFlexItem) : (0, _react2.jsx)(_react.default.Fragment, null, leftSideFlexItem, rightSideFlexItem)), bottomContentNode);
};