"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPageSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _restrict_width = require("../_restrict_width");
var _services = require("../../../services");
var _page_section = require("./page_section.styles");
var _global_styling = require("../../../global_styling");
var _react2 = require("@emotion/react");
var _excluded = ["children", "alignment", "restrictWidth", "bottomBorder", "paddingSize", "color", "grow", "contentProps", "component"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiPageSection = exports.EuiPageSection = function EuiPageSection(_ref) {
  var children = _ref.children,
    _ref$alignment = _ref.alignment,
    alignment = _ref$alignment === void 0 ? 'top' : _ref$alignment,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
    bottomBorder = _ref.bottomBorder,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'transparent' : _ref$color,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? false : _ref$grow,
    contentProps = _ref.contentProps,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'section' : _ref$component,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  // Set max-width as a style prop
  var widthStyles = (0, _restrict_width.setStyleForRestrictedPageWidth)(restrictWidth, contentProps === null || contentProps === void 0 ? void 0 : contentProps.style);
  var useTheme = (0, _services.useEuiTheme)();
  var styles = (0, _page_section.euiPageSectionStyles)(useTheme);
  var inlinePadding = (0, _global_styling.useEuiPaddingCSS)('horizontal');
  var blockPadding = (0, _global_styling.useEuiPaddingCSS)('vertical');
  var colors = (0, _global_styling.useEuiBackgroundColorCSS)();
  var cssStyles = [styles.euiPageSection, grow && styles.grow, inlinePadding[paddingSize], bottomBorder === 'extended' && styles.border, alignment && styles[alignment], colors[color]];
  var contentStyles = (0, _page_section.euiPageSectionContentStyles)();
  var cssContentStyles = [contentStyles.euiPageSection__content, blockPadding[paddingSize], bottomBorder === true && styles.border, alignment.toLowerCase().includes('center') && contentStyles.center, restrictWidth && contentStyles.restrictWidth, contentProps === null || contentProps === void 0 ? void 0 : contentProps.css];
  return (0, _react2.jsx)(Component, (0, _extends2.default)({
    css: cssStyles
  }, rest), (0, _react2.jsx)("div", (0, _extends2.default)({}, contentProps, {
    css: cssContentStyles,
    style: widthStyles
  }), children));
};