"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof3 = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPageSidebar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _global_styling = require("../../../global_styling");
var _services = require("../../../services");
var _page_sidebar = require("./page_sidebar.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "sticky", "paddingSize", "minWidth", "responsive", "hasEmbellish", "style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof3(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiPageSidebar = exports.EuiPageSidebar = function EuiPageSidebar(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$sticky = _ref.sticky,
    sticky = _ref$sticky === void 0 ? false : _ref$sticky,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _ref$minWidth = _ref.minWidth,
    minWidth = _ref$minWidth === void 0 ? 248 : _ref$minWidth,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
    _ref$hasEmbellish = _ref.hasEmbellish,
    hasEmbellish = _ref$hasEmbellish === void 0 ? false : _ref$hasEmbellish,
    style = _ref.style,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var themeContext = (0, _services.useEuiTheme)();
  var styles = (0, _page_sidebar.euiPageSidebarStyles)(themeContext);
  var isResponding = (0, _services.useIsWithinBreakpoints)(responsive);
  var cssStyles = [styles.euiPageSidebar, !isResponding && sticky && styles.sticky, hasEmbellish && styles.embellish, (0, _global_styling.useEuiPaddingCSS)()[paddingSize]];

  // Inline styles for setting up width and sticky offsets
  var _useState = (0, _react.useState)(_objectSpread(_objectSpread({}, style), (0, _global_styling.logicalStyle)('min-width', isResponding ? '100%' : minWidth))),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    inlineStyles = _useState2[0],
    setInlineStyles = _useState2[1];
  (0, _react.useLayoutEffect)(function () {
    var updatedStyles = _objectSpread(_objectSpread({}, style), (0, _global_styling.logicalStyle)('min-width', isResponding ? '100%' : minWidth));
    if (sticky) {
      var offset = (0, _typeof2.default)(sticky) === 'object' ? "".concat(sticky === null || sticky === void 0 ? void 0 : sticky.offset, "px") : 'var(--euiFixedHeadersOffset, 0)';
      updatedStyles = _objectSpread(_objectSpread(_objectSpread({}, updatedStyles), (0, _global_styling.logicalStyle)('top', offset)), (0, _global_styling.logicalStyle)('max-height', "calc(100vh - ".concat(offset, ")")));
    }
    setInlineStyles(updatedStyles);
  }, [style, sticky, themeContext.euiTheme.base, isResponding, minWidth]);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    className: className,
    css: cssStyles,
    style: inlineStyles
  }, rest), children);
};