"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._EuiPageEmptyPrompt = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _empty_prompt = require("../../empty_prompt");
var _page_section = require("../../page/page_section");
var _react2 = require("@emotion/react");
var _excluded = ["children", "alignment", "restrictWidth", "paddingSize", "grow", "panelled", "color"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _EuiPageEmptyPrompt = exports._EuiPageEmptyPrompt = function _EuiPageEmptyPrompt(_ref) {
  var children = _ref.children,
    _ref$alignment = _ref.alignment,
    alignment = _ref$alignment === void 0 ? 'center' : _ref$alignment,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    panelled = _ref.panelled,
    color = _ref.color,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  /**
   * If panelled = true, then either the section or empty prompt must be plain;
   * If color is anything but plain, then it must be the section that is plain;
   * If panelled = true, but color is undefined, then default to the empty prompt being plain;
   */

  var sectionColor;
  var emptyPromptColor;
  if (panelled && color === undefined) {
    sectionColor = 'plain';
    emptyPromptColor = 'subdued';
  } else if (panelled && color !== 'plain') {
    sectionColor = 'plain';
    emptyPromptColor = color;
  } else {
    sectionColor = 'transparent';
    emptyPromptColor = color || 'plain';
  }
  return (0, _react2.jsx)(_page_section.EuiPageSection, {
    paddingSize: paddingSize,
    color: sectionColor,
    grow: grow,
    restrictWidth: restrictWidth,
    alignment: alignment
  }, (0, _react2.jsx)(_empty_prompt.EuiEmptyPrompt
  // @ts-expect-error Hasn't been updated to use all the new values yet
  , (0, _extends2.default)({
    paddingSize: paddingSize,
    color: emptyPromptColor,
    body: children
  }, rest)));
};