"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._EuiPageOuter = exports.PAGE_DIRECTIONS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _services = require("../../../services");
var _page_outer = require("./page_outer.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "grow", "direction", "responsive"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var PAGE_DIRECTIONS = exports.PAGE_DIRECTIONS = ['row', 'column'];
var _EuiPageOuter = exports._EuiPageOuter = function _EuiPageOuter(_ref) {
  var children = _ref.children,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'row' : _ref$direction,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var themeContext = (0, _services.useEuiTheme)();
  var styles = (0, _page_outer.euiPageOuterStyles)(themeContext);
  var isResponding = (0, _services.useIsWithinBreakpoints)(responsive);
  var cssStyles = [styles.euiPageOuter, styles[isResponding ? 'column' : direction], grow && styles.grow];
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: cssStyles
  }, rest), children);
};