"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._EuiPageTemplate = exports.TemplateContext = exports.EuiPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _outer = require("./outer");
var _inner = require("./inner");
var _page_bottom_bar = require("./bottom_bar/page_bottom_bar");
var _page_empty_prompt = require("./empty_prompt/page_empty_prompt");
var _page = require("../page");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _react2 = require("@emotion/react");
var _excluded = ["children", "responsive", "restrictWidth", "paddingSize", "grow", "bottomBorder", "offset", "panelled", "contentBorder", "component", "mainProps", "className", "minHeight", "style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var TemplateContext = exports.TemplateContext = /*#__PURE__*/(0, _react.createContext)({
  sidebar: {},
  section: {},
  header: {},
  emptyPrompt: {},
  bottomBar: {}
});
/**
 * Consumed via `EuiPageTemplate`,
 * it controls and propogates most of the shared props per direct child
 */
var _EuiPageTemplate = exports._EuiPageTemplate = function _EuiPageTemplate(_ref) {
  var children = _ref.children,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? true : _ref$restrictWidth,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    bottomBorder = _ref.bottomBorder,
    offset = _ref.offset,
    panelled = _ref.panelled,
    contentBorder = _ref.contentBorder,
    component = _ref.component,
    mainProps = _ref.mainProps,
    className = _ref.className,
    _ref$minHeight = _ref.minHeight,
    minHeight = _ref$minHeight === void 0 ? '460px' : _ref$minHeight,
    style = _ref.style,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  // Used as a target to insert the bottom bar component
  var pageInnerId = (0, _services.useGeneratedHtmlId)({
    prefix: 'EuiPageTemplateInner',
    conditionalId: mainProps === null || mainProps === void 0 ? void 0 : mainProps.id
  });

  // Sections include page header
  var _useMemo = (0, _react.useMemo)(function () {
      var sidebar = [];
      var sections = [];
      _react.default.Children.toArray(children).forEach(function (child) {
        if (! /*#__PURE__*/_react.default.isValidElement(child)) return; // Skip non-components

        if (child.type === _EuiPageSidebar || child.props.__EMOTION_TYPE_PLEASE_DO_NOT_USE__ === _EuiPageSidebar) {
          sidebar.push(child);
        } else {
          sections.push(child);
        }
      });
      return [sidebar, sections];
    }, [children]),
    _useMemo2 = (0, _slicedToArray2.default)(_useMemo, 2),
    sidebar = _useMemo2[0],
    sections = _useMemo2[1];
  var classes = (0, _classnames.default)('euiPageTemplate', className);
  var pageStyle = (0, _react.useMemo)(function () {
    return (0, _global_styling.logicalStyles)(_objectSpread({
      minHeight: grow ? "max(".concat(minHeight, ", 100vh)") : minHeight,
      paddingTop: offset !== null && offset !== void 0 ? offset : 'var(--euiFixedHeadersOffset, 0)'
    }, style));
  }, [minHeight, grow, offset, style]);
  var innerPanelled = panelled !== null && panelled !== void 0 ? panelled : Boolean(sidebar.length > 0);
  var innerBordered = contentBorder !== null && contentBorder !== void 0 ? contentBorder : Boolean(sidebar.length > 0);
  var headerBottomBorder = bottomBorder !== null && bottomBorder !== void 0 ? bottomBorder : sidebar.length ? true : 'extended';
  var templateContext = (0, _react.useMemo)(function () {
    return {
      sidebar: {
        paddingSize: paddingSize,
        responsive: responsive
      },
      header: {
        restrictWidth: restrictWidth,
        paddingSize: paddingSize,
        bottomBorder: headerBottomBorder
      },
      section: {
        restrictWidth: restrictWidth,
        paddingSize: paddingSize,
        color: panelled === false ? 'transparent' : 'plain',
        grow: true
      },
      emptyPrompt: {
        panelled: innerPanelled ? true : panelled,
        grow: true
      },
      bottomBar: {
        restrictWidth: restrictWidth,
        paddingSize: paddingSize,
        // pageInnerId may contain colons that are parsed as pseudo-elements if not escaped
        parent: "#".concat(pageInnerId.replaceAll(':', '\\:'))
      }
    };
  }, [pageInnerId, restrictWidth, responsive, paddingSize, panelled, innerPanelled, headerBottomBorder]);
  return (0, _react2.jsx)(TemplateContext.Provider, {
    value: templateContext
  }, (0, _react2.jsx)(_outer._EuiPageOuter, (0, _extends2.default)({}, rest, {
    responsive: responsive,
    style: pageStyle,
    className: classes
  }), sidebar, (0, _react2.jsx)(_inner._EuiPageInner, (0, _extends2.default)({}, mainProps, {
    component: component,
    id: pageInnerId,
    border: innerBordered,
    panelled: innerPanelled,
    responsive: responsive
  }), sections)));
};
var _EuiPageSidebar = function _EuiPageSidebar(props) {
  var _useContext = (0, _react.useContext)(TemplateContext),
    sidebar = _useContext.sidebar;
  return (0, _react2.jsx)(_page.EuiPageSidebar, (0, _extends2.default)({}, sidebar, props));
};
var _EuiPageSection = function _EuiPageSection(props) {
  var _useContext2 = (0, _react.useContext)(TemplateContext),
    section = _useContext2.section;
  return (0, _react2.jsx)(_page.EuiPageSection, (0, _extends2.default)({}, section, props));
};
var _EuiPageHeader = function _EuiPageHeader(props) {
  var _useContext3 = (0, _react.useContext)(TemplateContext),
    header = _useContext3.header;
  return (0, _react2.jsx)(_page.EuiPageHeader, (0, _extends2.default)({}, header, props));
};
var _EuiPageEmptyPrompt = function _EuiPageEmptyPrompt(props) {
  var _useContext4 = (0, _react.useContext)(TemplateContext),
    emptyPrompt = _useContext4.emptyPrompt;
  return (0, _react2.jsx)(_page_empty_prompt._EuiPageEmptyPrompt, (0, _extends2.default)({}, emptyPrompt, props));
};
var _EuiPageBottomBar = function _EuiPageBottomBar(props) {
  var _useContext5 = (0, _react.useContext)(TemplateContext),
    bottomBar = _useContext5.bottomBar;
  return (0, _react2.jsx)(_page_bottom_bar._EuiPageBottomBar, (0, _extends2.default)({}, bottomBar, props));
};
var EuiPageTemplate = exports.EuiPageTemplate = Object.assign(_EuiPageTemplate, {
  Sidebar: _EuiPageSidebar,
  Header: _EuiPageHeader,
  Section: _EuiPageSection,
  BottomBar: _EuiPageBottomBar,
  EmptyPrompt: _EuiPageEmptyPrompt
});