"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _pagination = require("./pagination");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var Pagination = function Pagination() {
  var _useState = (0, _react.useState)(0),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    activePage = _useState2[0],
    setActivePage = _useState2[1];
  return (0, _react2.jsx)(_pagination.EuiPagination, {
    "aria-label": "Many pages example",
    pageCount: 22,
    activePage: activePage,
    onPageClick: function onPageClick(activePage) {
      return setActivePage(activePage);
    }
  });
};
describe('EuiPagination', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first mobile render', function () {
      cy.viewport(375, 667); // small breakpoint
      cy.mount((0, _react2.jsx)(Pagination, null));
      cy.get('nav.euiPagination').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when rendered using non-mobile breakpoint', function () {
      cy.viewport(1280, 800); //macbook-13
      cy.mount((0, _react2.jsx)(Pagination, null));
      cy.get('nav.euiPagination').should('exist');
      cy.checkAxe();
    });
  });
});