"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiInputPopoverWidthContext = exports.EuiInputPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _classnames = _interopRequireDefault(require("classnames"));
var _tabbable = require("tabbable");
var _global_styling = require("../../global_styling");
var _services = require("../../services");
var _resize_observer = require("../observer/resize_observer");
var _focus_trap = require("../focus_trap");
var _form = require("../form/form.styles");
var _popover = require("./popover");
var _excluded = ["children", "className", "closePopover", "anchorPosition", "attachToAnchor", "repositionToCrossAxis", "display", "panelPaddingSize", "closeOnScroll", "ownFocus", "disableFocusTrap", "focusTrapProps", "input", "fullWidth", "panelMinWidth", "onPanelResize", "inputRef", "panelRef"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
// Used by child components that want to know the parent popover width
var EuiInputPopoverWidthContext = exports.EuiInputPopoverWidthContext = /*#__PURE__*/(0, _react.createContext)(0);
var EuiInputPopover = exports.EuiInputPopover = function EuiInputPopover(_ref) {
  var _props$panelProps;
  var children = _ref.children,
    className = _ref.className,
    closePopover = _ref.closePopover,
    _ref$anchorPosition = _ref.anchorPosition,
    anchorPosition = _ref$anchorPosition === void 0 ? 'downLeft' : _ref$anchorPosition,
    _ref$attachToAnchor = _ref.attachToAnchor,
    attachToAnchor = _ref$attachToAnchor === void 0 ? true : _ref$attachToAnchor,
    _ref$repositionToCros = _ref.repositionToCrossAxis,
    repositionToCrossAxis = _ref$repositionToCros === void 0 ? false : _ref$repositionToCros,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'block' : _ref$display,
    _ref$panelPaddingSize = _ref.panelPaddingSize,
    panelPaddingSize = _ref$panelPaddingSize === void 0 ? 's' : _ref$panelPaddingSize,
    _ref$closeOnScroll = _ref.closeOnScroll,
    closeOnScroll = _ref$closeOnScroll === void 0 ? false : _ref$closeOnScroll,
    _ref$ownFocus = _ref.ownFocus,
    ownFocus = _ref$ownFocus === void 0 ? false : _ref$ownFocus,
    _ref$disableFocusTrap = _ref.disableFocusTrap,
    disableFocusTrap = _ref$disableFocusTrap === void 0 ? false : _ref$disableFocusTrap,
    focusTrapProps = _ref.focusTrapProps,
    input = _ref.input,
    _ref$fullWidth = _ref.fullWidth,
    fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
    _ref$panelMinWidth = _ref.panelMinWidth,
    panelMinWidth = _ref$panelMinWidth === void 0 ? 0 : _ref$panelMinWidth,
    onPanelResize = _ref.onPanelResize,
    _inputRef = _ref.inputRef,
    _panelRef = _ref.panelRef,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiInputPopover', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var formMaxWidth = (0, _form.euiFormMaxWidth)(euiTheme);

  /**
   * Ref setup
   */

  var popoverClassRef = (0, _react.useRef)(null);
  // The inputEl state ensures that width is correctly tracked on initial load
  var _useState = (0, _react.useState)(null),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    inputEl = _useState2[0],
    setInputEl = _useState2[1];
  // The panelEl state ensures that width is correctly set every time the popover opens
  var _useState3 = (0, _react.useState)(null),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    panelEl = _useState4[0],
    setPanelEl = _useState4[1];
  var inputRef = (0, _services.useCombinedRefs)([setInputEl, _inputRef]);
  var panelRef = (0, _services.useCombinedRefs)([setPanelEl, _panelRef]);

  /**
   * Sizing/width logic
   */

  var inputWidth = (0, _resize_observer.useResizeObserver)(inputEl, 'width').width;
  var panelWidth = (0, _react.useMemo)(function () {
    return inputWidth < panelMinWidth ? panelMinWidth : inputWidth;
  }, [panelMinWidth, inputWidth]);

  // Resize callback
  (0, _react.useEffect)(function () {
    onPanelResize === null || onPanelResize === void 0 || onPanelResize(panelWidth);
  }, [panelWidth, onPanelResize]);
  (0, _react.useEffect)(function () {
    if (panelEl) {
      // We have to modify the popover panel DOM node directly instead of using
      // `panelStyle`, as there's some weird positioning bugs on resize otherwise
      panelEl.style.inlineSize = "".concat(panelWidth, "px");
    }
  }, [panelEl, panelWidth]);
  (0, _react.useEffect)(function () {
    // This fires on all input width changes regardless of minimum size, because on
    // right/center anchored popovers, the input width affects the position of the popover
    if (panelEl) {
      var _popoverClassRef$curr;
      (_popoverClassRef$curr = popoverClassRef.current) === null || _popoverClassRef$curr === void 0 || _popoverClassRef$curr.positionPopoverFluid();
    }
  }, [inputWidth, panelEl]);

  /**
   * Popover tab to close logic
   */

  var panelPropsOnKeyDown = (_props$panelProps = props.panelProps) === null || _props$panelProps === void 0 ? void 0 : _props$panelProps.onKeyDown;
  var onKeyDown = (0, _react.useCallback)(function (event) {
    panelPropsOnKeyDown === null || panelPropsOnKeyDown === void 0 || panelPropsOnKeyDown(event);
    if (event.key === _services.keys.TAB) {
      if (disableFocusTrap) {
        if (!ownFocus) {
          closePopover();
        }
      } else {
        var tabbableItems = (0, _tabbable.tabbable)(event.currentTarget).filter(function (el) {
          return !el.hasAttribute('data-focus-guard');
        });
        if (!tabbableItems.length) return;
        var tabbingFromLastItemInPopover = document.activeElement === tabbableItems[tabbableItems.length - 1];
        if (tabbingFromLastItemInPopover) {
          closePopover();
        }
      }
    }
  }, [disableFocusTrap, ownFocus, closePopover, panelPropsOnKeyDown]);

  /**
   * Optional close on scroll behavior
   */

  (0, _react.useEffect)(function () {
    // When the popover opens, add a scroll listener to the page (& remove it after)
    if (closeOnScroll && panelEl) {
      var closePopoverOnScroll = function closePopoverOnScroll(event) {
        var scrollTarget = event.target;

        // Basic existence check
        if (!panelEl || !inputEl || !scrollTarget) {
          return;
        }
        // Do not close the popover if the input or popover itself was scrolled
        if (panelEl.contains(scrollTarget) || inputEl.contains(scrollTarget)) {
          return;
        }
        // Firefox will trigger a scroll event in many common situations (e.g. docs side nav)
        // when the options list div is appended to the DOM. To work around this, we should
        // check if the element that scrolled actually contains/will affect the input
        if (!scrollTarget.contains(inputEl)) {
          return;
        }
        closePopover();
      };

      // Kibana Cypress tests trigger a scroll event in many common situations when the options list div is appended
      // to the DOM; in testing it was always within 100ms, but setting a timeout here for 500ms to be safe
      var timeoutId = setTimeout(function () {
        window.addEventListener('scroll', closePopoverOnScroll, {
          passive: true,
          // for better performance as we won't call preventDefault
          capture: true // scroll events don't bubble, they must be captured instead
        });
      }, 500);
      return function () {
        window.removeEventListener('scroll', closePopoverOnScroll, {
          capture: true
        });
        clearTimeout(timeoutId);
      };
    }
  }, [closeOnScroll, closePopover, panelEl, inputEl]);
  return (0, _react2.jsx)(_popover.EuiPopover, (0, _extends2.default)({
    className: classes,
    css: /*#__PURE__*/(0, _react2.css)(fullWidth ? undefined : (0, _global_styling.logicalCSS)('max-width', formMaxWidth), ";label:EuiInputPopover;"),
    display: display,
    button: input,
    popoverRef: inputRef,
    panelRef: panelRef,
    ref: popoverClassRef,
    closePopover: closePopover,
    anchorPosition: anchorPosition,
    attachToAnchor: attachToAnchor,
    repositionToCrossAxis: repositionToCrossAxis,
    panelPaddingSize: panelPaddingSize,
    ownFocus: ownFocus
  }, props, {
    panelProps: _objectSpread(_objectSpread({}, props.panelProps), {}, {
      onKeyDown: onKeyDown
    })
  }), (0, _react2.jsx)(_focus_trap.EuiFocusTrap, (0, _extends2.default)({
    clickOutsideDisables: true,
    disabled: disableFocusTrap
  }, focusTrapProps), (0, _react2.jsx)(EuiInputPopoverWidthContext.Provider, {
    value: panelWidth
  }, children)));
};