"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _popover = require("./popover");
var _button = require("../button");
var _text = require("../text");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var Popover = function Popover() {
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var onButtonClick = function onButtonClick() {
    return setIsPopoverOpen(function (isPopoverOpen) {
      return !isPopoverOpen;
    });
  };
  var closePopover = function closePopover() {
    return setIsPopoverOpen(false);
  };
  var button = (0, _react2.jsx)(_button.EuiButtonEmpty, {
    iconType: "documentation",
    iconSide: "right",
    onClick: onButtonClick
  }, "How it works");
  var popoverProps = {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  };
  return (0, _react2.jsx)(_popover.EuiPopover, popoverProps, (0, _react2.jsx)(_text.EuiText, {
    style: {
      width: 300
    }
  }, (0, _react2.jsx)("p", null, "Popover content that\u2019s wider than the default width")));
};
beforeEach(function () {
  cy.mount((0, _react2.jsx)(Popover, null));
  cy.get('div.euiPopover__panel').should('not.exist');
});
describe('EuiPopover', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when popover is opened', function () {
      cy.get('button.euiButtonEmpty').click();
      cy.get('div.euiPopover__panel').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when popover is closed', function () {
      cy.get('button.euiButtonEmpty').click();
      cy.get('div.euiPopover__panel').should('exist');
      cy.get('button.euiButtonEmpty').click();
      cy.get('div.euiPopover__panel').should('not.exist');
      cy.checkAxe();
    });
  });
});