"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPopover = void 0;
exports.getPopoverAlignFromAnchorPosition = getPopoverAlignFromAnchorPosition;
exports.getPopoverPositionFromAnchorPosition = getPopoverPositionFromAnchorPosition;
exports.popoverAnchorPosition = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _tabbable = require("tabbable");
var _focus_trap = require("../focus_trap");
var _services = require("../../services");
var _useCombinedRefs = require("../../services/hooks/useCombinedRefs");
var _accessibility = require("../accessibility");
var _portal = require("../portal");
var _mutation_observer = require("../observer/mutation_observer");
var _popover = require("../../services/popover");
var _i18n = require("../i18n");
var _outside_click_detector = require("../outside_click_detector");
var _popover_arrow = require("./popover_arrow");
var _popover2 = require("./popover.styles");
var _popover_panel = require("./popover_panel");
var _react2 = require("@emotion/react");
var _excluded = ["anchorPosition", "button", "insert", "isOpen", "ownFocus", "children", "className", "closePopover", "panelClassName", "panelPaddingSize", "panelProps", "panelRef", "panelStyle", "popoverScreenReaderText", "popoverRef", "hasArrow", "arrowChildren", "repositionOnScroll", "repositionToCrossAxis", "zIndex", "attachToAnchor", "display", "offset", "onPositionChange", "buffer", "aria-label", "aria-labelledby", "container", "focusTrapProps", "initialFocus", "tabIndex"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var popoverAnchorPosition = exports.popoverAnchorPosition = ['upCenter', 'upLeft', 'upRight', 'downCenter', 'downLeft', 'downRight', 'leftCenter', 'leftUp', 'leftDown', 'rightCenter', 'rightUp', 'rightDown'];
var anchorPositionToPopoverPositionMap = {
  up: 'top',
  right: 'right',
  down: 'bottom',
  left: 'left'
};
function getPopoverPositionFromAnchorPosition(anchorPosition) {
  // maps the anchor position to the matching popover position
  // e.g. "upLeft" -> "top", "downRight" -> "bottom"

  // extract the first positional word from anchorPosition:
  // starts at the beginning (" ^ ") of anchorPosition and
  // captures all of the characters (" (.*?) ") until the
  // first capital letter (" [A-Z] ") is encountered
  var _ref = anchorPosition.match(/^(.*?)[A-Z]/),
    _ref2 = (0, _slicedToArray2.default)(_ref, 2),
    primaryPosition = _ref2[1];
  return anchorPositionToPopoverPositionMap[primaryPosition];
}
function getPopoverAlignFromAnchorPosition(anchorPosition) {
  // maps the gravity to the matching popover position
  // e.g. "upLeft" -> "left", "rightDown" -> "bottom"

  // extract the second positional word from anchorPosition:
  // starts a capture group at the first capital letter
  // and includes everything after it
  var _ref3 = anchorPosition.match(/([A-Z].*)/),
    _ref4 = (0, _slicedToArray2.default)(_ref3, 2),
    align = _ref4[1];

  // this performs two tasks:
  // 1. normalizes the align position by lowercasing it
  // 2. `center` doesn't exist in the lookup map which converts it to `undefined` meaning no align
  return anchorPositionToPopoverPositionMap[align.toLowerCase()];
}
var DEFAULT_POPOVER_STYLES = {
  top: 50,
  left: 50
};
var returnFocusConfig = {
  preventScroll: true
};
var closingTransitionTime = 250; // TODO: DRY out var when converting to CSS-in-JS
var EuiPopover = exports.EuiPopover = /*#__PURE__*/function (_Component) {
  function EuiPopover(props) {
    var _this;
    (0, _classCallCheck2.default)(this, EuiPopover);
    _this = _callSuper(this, EuiPopover, [props]);
    (0, _defineProperty2.default)(_this, "respositionTimeout", void 0);
    (0, _defineProperty2.default)(_this, "strandedFocusTimeout", void 0);
    (0, _defineProperty2.default)(_this, "closingTransitionTimeout", void 0);
    (0, _defineProperty2.default)(_this, "closingTransitionAnimationFrame", void 0);
    (0, _defineProperty2.default)(_this, "button", null);
    (0, _defineProperty2.default)(_this, "panel", null);
    (0, _defineProperty2.default)(_this, "descriptionId", (0, _services.htmlIdGenerator)()());
    (0, _defineProperty2.default)(_this, "closePopover", function () {
      if (_this.props.isOpen) {
        _this.props.closePopover();
      }
    });
    (0, _defineProperty2.default)(_this, "onEscapeKey", function (event) {
      if (_this.props.isOpen) {
        event.preventDefault();
        event.stopPropagation();
        _this.closePopover();
        _this.handleStrandedFocus();
      }
    });
    (0, _defineProperty2.default)(_this, "handleStrandedFocus", function () {
      _this.strandedFocusTimeout = window.setTimeout(function () {
        var _this$panel;
        // If `returnFocus` failed and focus was stranded,
        // attempt to manually restore focus to the toggle button.
        // The stranded focus is either in most cases on body but
        // it will be on the panel instead on mount when isOpen=true
        if (document.activeElement === document.body || (_this$panel = _this.panel) !== null && _this$panel !== void 0 && _this$panel.contains(document.activeElement) // if focus is on OR within this.panel
        ) {
          if (!_this.button) return;
          var focusableItems = (0, _tabbable.focusable)(_this.button);
          if (!focusableItems.length) return;
          var toggleButton = focusableItems[0];
          toggleButton.focus(returnFocusConfig);
        }
      }, closingTransitionTime);
    });
    (0, _defineProperty2.default)(_this, "onKeyDown", function (event) {
      if (event.key === _services.keys.ESCAPE) {
        _this.onEscapeKey(event);
      }
    });
    (0, _defineProperty2.default)(_this, "onClickOutside", function (event) {
      // only close the popover if the event source isn't the anchor button
      // otherwise, it is up to the anchor to toggle the popover's open status
      if (_this.button && _this.button.contains(event.target) === false) {
        _this.closePopover();
      }
    });
    (0, _defineProperty2.default)(_this, "onOpenPopover", function () {
      clearTimeout(_this.strandedFocusTimeout);
      clearTimeout(_this.closingTransitionTimeout);
      if (_this.closingTransitionAnimationFrame) {
        cancelAnimationFrame(_this.closingTransitionAnimationFrame);
      }
      // We need to set this state a beat after the render takes place, so that the CSS
      // transition can take effect.
      _this.closingTransitionAnimationFrame = window.requestAnimationFrame(function () {
        _this.setState({
          isOpening: true
        });
      });

      // for each child element of `this.panel`, find any transition duration we should wait for before stabilizing
      var _Array$prototype$slic = Array.prototype.slice.call(_this.panel ? [_this.panel].concat((0, _toConsumableArray2.default)(Array.from(_this.panel.children))) : []).reduce(function (_ref5, element) {
          var durationMatch = _ref5.durationMatch,
            delayMatch = _ref5.delayMatch;
          var transitionTimings = (0, _services.getTransitionTimings)(element);
          return {
            durationMatch: Math.max(durationMatch, transitionTimings.durationMatch),
            delayMatch: Math.max(delayMatch, transitionTimings.delayMatch)
          };
        }, {
          durationMatch: 0,
          delayMatch: 0
        }),
        durationMatch = _Array$prototype$slic.durationMatch,
        delayMatch = _Array$prototype$slic.delayMatch;
      clearTimeout(_this.respositionTimeout);
      _this.respositionTimeout = window.setTimeout(function () {
        _this.setState({
          isOpenStable: true
        }, function () {
          _this.positionPopoverFixed();
        });
      }, durationMatch + delayMatch);
    });
    (0, _defineProperty2.default)(_this, "onMutation", function (records) {
      var waitDuration = (0, _services.getWaitDuration)(records);
      _this.positionPopoverFixed();
      (0, _services.performOnFrame)(waitDuration, _this.positionPopoverFixed);
    });
    (0, _defineProperty2.default)(_this, "positionPopover", function (allowEnforcePosition) {
      if (_this.button == null || _this.panel == null) return;
      var _ref6 = _this.props,
        anchorPosition = _ref6.anchorPosition,
        _ref6$offset = _ref6.offset,
        offset = _ref6$offset === void 0 ? 0 : _ref6$offset;
      var position = getPopoverPositionFromAnchorPosition(anchorPosition);
      var forcePosition = undefined;
      if (allowEnforcePosition && _this.state.isOpenStable && _this.state.openPosition != null) {
        position = _this.state.openPosition;
        forcePosition = true;
      }
      var _findPopoverPosition = (0, _popover.findPopoverPosition)({
          container: _this.props.container,
          position: position,
          forcePosition: forcePosition,
          align: getPopoverAlignFromAnchorPosition(anchorPosition),
          anchor: _this.button,
          popover: _this.panel,
          offset: _this.props.attachToAnchor ? offset : _this.props.hasArrow ? 16 + offset : 8 + offset,
          arrowConfig: _this.props.hasArrow ? {
            arrowWidth: 24,
            arrowBuffer: 10
          } : {
            arrowWidth: 0,
            arrowBuffer: 0
          },
          returnBoundingBox: _this.props.attachToAnchor,
          allowCrossAxis: _this.props.repositionToCrossAxis,
          buffer: _this.props.buffer
        }),
        top = _findPopoverPosition.top,
        left = _findPopoverPosition.left,
        foundPosition = _findPopoverPosition.position,
        arrow = _findPopoverPosition.arrow;

      // the popover's z-index must inherit from the button
      // this keeps a button's popover under a flyout that would cover the button
      // but a popover triggered inside a flyout will appear over that flyout
      var zIndexProp = _this.props.zIndex;
      var zIndex = zIndexProp == null ? (0, _popover.getElementZIndex)(_this.button, _this.panel) + 2000 : zIndexProp;
      var popoverStyles = _objectSpread(_objectSpread({}, _this.props.panelStyle), {}, {
        top: top,
        left: left,
        zIndex: zIndex
      });
      var willRenderArrow = !_this.props.attachToAnchor && _this.props.hasArrow;
      var arrowStyles = willRenderArrow ? arrow : undefined;
      var arrowPosition = foundPosition;
      _this.props.onPositionChange && _this.props.onPositionChange(arrowPosition);
      _this.setState({
        popoverStyles: popoverStyles,
        arrowStyles: arrowStyles,
        arrowPosition: arrowPosition,
        openPosition: foundPosition
      });
    });
    (0, _defineProperty2.default)(_this, "positionPopoverFixed", function () {
      _this.positionPopover(true);
    });
    (0, _defineProperty2.default)(_this, "positionPopoverFluid", function () {
      _this.positionPopover(false);
    });
    (0, _defineProperty2.default)(_this, "panelRef", function (node) {
      _this.panel = node;
      _this.props.panelRef && _this.props.panelRef(node);
      if (node == null) {
        // panel has unmounted, restore the state defaults
        _this.setState({
          popoverStyles: DEFAULT_POPOVER_STYLES,
          arrowStyles: {},
          arrowPosition: null,
          openPosition: null,
          isOpenStable: false
        });
        window.removeEventListener('resize', _this.positionPopoverFluid);
      } else {
        // panel is coming into existence
        _this.positionPopoverFluid();
        window.addEventListener('resize', _this.positionPopoverFluid);
      }
    });
    (0, _defineProperty2.default)(_this, "popoverRef", function (node) {
      _this.button = node;
      (0, _useCombinedRefs.setMultipleRefs)([_this.props.popoverRef], node);
    });
    _this.state = {
      prevProps: {
        isOpen: props.isOpen
      },
      suppressingPopover: props.isOpen,
      // only suppress if created with isOpen=true
      isClosing: false,
      isOpening: false,
      popoverStyles: DEFAULT_POPOVER_STYLES,
      arrowStyles: {},
      arrowPosition: null,
      openPosition: null,
      // once a stable position has been found, keep the contents on that side
      isOpenStable: false // wait for any initial opening transitions to finish before marking as stable
    };
    return _this;
  }
  (0, _inherits2.default)(EuiPopover, _Component);
  return (0, _createClass2.default)(EuiPopover, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;
      if (this.state.suppressingPopover) {
        // component was created with isOpen=true; now that it's mounted
        // stop suppressing and start opening
        this.setState({
          suppressingPopover: false,
          isOpening: true
        }, function () {
          _this2.onOpenPopover();
        });
      }
      if (this.props.repositionOnScroll) {
        window.addEventListener('scroll', this.positionPopoverFixed, true);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this3 = this;
      // The popover is being opened.
      if (!prevProps.isOpen && this.props.isOpen) {
        this.onOpenPopover();
      }

      // ensure recalculation of panel position on prop updates
      if (this.props.isOpen && (prevProps.anchorPosition !== this.props.anchorPosition || prevProps.buffer !== this.props.buffer || prevProps.offset !== this.props.offset || prevProps.panelPaddingSize !== this.props.panelPaddingSize)) {
        this.positionPopoverFluid();
      }

      // update scroll listener
      if (prevProps.repositionOnScroll !== this.props.repositionOnScroll) {
        if (this.props.repositionOnScroll) {
          window.addEventListener('scroll', this.positionPopoverFixed, true);
        } else {
          window.removeEventListener('scroll', this.positionPopoverFixed, true);
        }
      }

      // The popover is being closed.
      if (prevProps.isOpen && !this.props.isOpen) {
        // If the user has just closed the popover, queue up the removal of the content after the
        // transition is complete.
        this.closingTransitionTimeout = window.setTimeout(function () {
          _this3.setState({
            isClosing: false
          });
        }, closingTransitionTime);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      window.removeEventListener('scroll', this.positionPopoverFixed, true);
      clearTimeout(this.respositionTimeout);
      clearTimeout(this.strandedFocusTimeout);
      clearTimeout(this.closingTransitionTimeout);
      cancelAnimationFrame(this.closingTransitionAnimationFrame);
    }
  }, {
    key: "render",
    value: function render() {
      var _panelProps$tabIndex,
        _this4 = this;
      var _this$props = this.props,
        anchorPosition = _this$props.anchorPosition,
        button = _this$props.button,
        insert = _this$props.insert,
        isOpen = _this$props.isOpen,
        ownFocus = _this$props.ownFocus,
        children = _this$props.children,
        className = _this$props.className,
        closePopover = _this$props.closePopover,
        panelClassName = _this$props.panelClassName,
        panelPaddingSize = _this$props.panelPaddingSize,
        panelProps = _this$props.panelProps,
        panelRef = _this$props.panelRef,
        panelStyle = _this$props.panelStyle,
        popoverScreenReaderText = _this$props.popoverScreenReaderText,
        popoverRef = _this$props.popoverRef,
        hasArrow = _this$props.hasArrow,
        arrowChildren = _this$props.arrowChildren,
        repositionOnScroll = _this$props.repositionOnScroll,
        repositionToCrossAxis = _this$props.repositionToCrossAxis,
        zIndex = _this$props.zIndex,
        attachToAnchor = _this$props.attachToAnchor,
        display = _this$props.display,
        offset = _this$props.offset,
        onPositionChange = _this$props.onPositionChange,
        buffer = _this$props.buffer,
        ariaLabel = _this$props['aria-label'],
        ariaLabelledBy = _this$props['aria-labelledby'],
        container = _this$props.container,
        focusTrapProps = _this$props.focusTrapProps,
        initialFocusProp = _this$props.initialFocus,
        _tabIndexProp = _this$props.tabIndex,
        rest = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var tabIndexProp = (_panelProps$tabIndex = panelProps === null || panelProps === void 0 ? void 0 : panelProps.tabIndex) !== null && _panelProps$tabIndex !== void 0 ? _panelProps$tabIndex : _tabIndexProp;
      var styles = (0, _popover2.euiPopoverStyles)();
      var popoverStyles = [styles.euiPopover, {
        display: display,
        label: display
      }];
      var classes = (0, _classnames.default)('euiPopover', {
        'euiPopover-isOpen': this.state.isOpening
      }, className);
      var showArrow = hasArrow && !attachToAnchor;
      var panel;
      if (!this.state.suppressingPopover && (isOpen || this.state.isClosing)) {
        var tabIndex = tabIndexProp;
        var initialFocus = initialFocusProp;
        var ariaDescribedby;
        var ariaLive;
        var panelAriaModal = panelProps !== null && panelProps !== void 0 && panelProps.hasOwnProperty('aria-modal') ? panelProps['aria-modal'] : 'true';
        var panelRole = panelProps !== null && panelProps !== void 0 && panelProps.hasOwnProperty('role') ? panelProps.role : 'dialog';
        if (ownFocus || panelAriaModal !== 'true') {
          tabIndex = tabIndexProp !== null && tabIndexProp !== void 0 ? tabIndexProp : 0;
          ariaLive = 'off';
          if (!initialFocus) {
            initialFocus = function initialFocus() {
              return _this4.panel;
            };
          }
        } else {
          ariaLive = 'assertive';
        }
        var focusTrapScreenReaderText;
        if (ownFocus || popoverScreenReaderText) {
          ariaDescribedby = this.descriptionId;
          focusTrapScreenReaderText = (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
            id: this.descriptionId
          }, ownFocus && (0, _react2.jsx)(_i18n.EuiI18n, {
            token: "euiPopover.screenReaderAnnouncement",
            default: "You are in a dialog. Press Escape, or tap/click outside the dialog to close."
          }), popoverScreenReaderText));
        }
        var returnFocus = this.state.isOpenStable ? returnFocusConfig : false;
        panel = (0, _react2.jsx)(_portal.EuiPortal, insert && {
          insert: insert
        }, (0, _react2.jsx)(_focus_trap.EuiFocusTrap, (0, _extends2.default)({
          clickOutsideDisables: true,
          onClickOutside: this.onClickOutside,
          returnFocus: returnFocus // Ignore temporary state of indecisive focus
          ,
          initialFocus: initialFocus,
          onEscapeKey: this.onEscapeKey,
          disabled: !ownFocus || !this.state.isOpenStable || this.state.isClosing
        }, focusTrapProps), (0, _react2.jsx)(_popover_panel.EuiPopoverPanel, (0, _extends2.default)({}, panelProps, {
          panelRef: this.panelRef,
          isOpen: this.state.isOpening,
          position: this.state.arrowPosition,
          isAttached: attachToAnchor,
          className: (0, _classnames.default)(panelClassName, panelProps === null || panelProps === void 0 ? void 0 : panelProps.className),
          hasShadow: false,
          paddingSize: panelPaddingSize,
          tabIndex: tabIndex,
          "aria-live": ariaLive,
          role: panelRole,
          "aria-label": ariaLabel,
          "aria-labelledby": ariaLabelledBy,
          "aria-modal": panelAriaModal,
          "aria-describedby": ariaDescribedby,
          style: _objectSpread(_objectSpread({}, this.state.popoverStyles), {}, {
            // Adding `will-change` to reduce risk of a blurry animation in Chrome 86+
            willChange: !this.state.isOpenStable ? 'transform, opacity' : undefined
          })
        }), showArrow && this.state.arrowPosition && (0, _react2.jsx)(_popover_arrow.EuiPopoverArrow, {
          position: this.state.arrowPosition,
          style: this.state.arrowStyles
        }, arrowChildren), focusTrapScreenReaderText, (0, _react2.jsx)(_mutation_observer.EuiMutationObserver, {
          observerOptions: {
            attributes: true,
            // element attribute changes
            childList: true,
            // added/removed elements
            characterData: true,
            // text changes
            subtree: true // watch all child elements
          },
          onMutation: this.onMutation
        }, function (mutationRef) {
          return (0, _react2.jsx)("div", {
            ref: mutationRef
          }, children);
        }))));
      }

      // react-focus-on and related do not register outside click detection
      // when disabled, so we still need to conditionally check for that ourselves
      if (ownFocus) {
        return (0, _react2.jsx)("div", (0, _extends2.default)({
          css: popoverStyles,
          className: classes,
          ref: this.popoverRef
        }, rest), button instanceof HTMLElement ? null : button, panel);
      } else {
        return (0, _react2.jsx)(_outside_click_detector.EuiOutsideClickDetector, {
          onOutsideClick: this.closePopover
        }, (0, _react2.jsx)("div", (0, _extends2.default)({
          css: popoverStyles,
          className: classes,
          ref: this.popoverRef,
          onKeyDown: this.onKeyDown
        }, rest), button instanceof HTMLElement ? null : button, panel));
      }
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (prevState.prevProps.isOpen && !nextProps.isOpen) {
        return {
          prevProps: {
            isOpen: nextProps.isOpen
          },
          isClosing: true,
          isOpening: false
        };
      }
      if (prevState.prevProps.isOpen !== nextProps.isOpen) {
        return {
          prevProps: {
            isOpen: nextProps.isOpen
          }
        };
      }
      return null;
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiPopover, "defaultProps", {
  isOpen: false,
  ownFocus: true,
  repositionToCrossAxis: true,
  anchorPosition: 'downCenter',
  panelPaddingSize: 'm',
  hasArrow: true,
  display: 'inline-block'
});