"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POSITIONS = exports.EuiPopoverArrow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _popover_arrow = require("./_popover_arrow.styles");
var _services = require("../../../services");
var _react2 = require("@emotion/react");
var _excluded = ["children", "position"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var POSITIONS = exports.POSITIONS = ['top', 'left', 'right', 'bottom'];
var EuiPopoverArrow = exports.EuiPopoverArrow = function EuiPopoverArrow(_ref) {
  var children = _ref.children,
    position = _ref.position,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _popover_arrow.euiPopoverArrowStyles)(euiTheme);
  var cssStyles = [styles.euiPopoverArrow, styles[position]];
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    className: "euiPopover__arrow",
    "data-popover-arrow": position,
    css: cssStyles
  }, rest), children);
};