"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _button = require("../button");
var _portal = require("./portal");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var Portal = function Portal() {
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isPortalVisible = _useState2[0],
    setIsPortalVisible = _useState2[1];
  var togglePortal = function togglePortal() {
    setIsPortalVisible(!isPortalVisible);
  };
  var closePortal = function closePortal() {
    setIsPortalVisible(false);
  };
  var customPortal;
  if (isPortalVisible) {
    customPortal = (0, _react2.jsx)(_portal.EuiPortal, null, (0, _react2.jsx)("div", null, "This is the portal. Click anywhere to close."), (0, _react2.jsx)(_button.EuiButton, {
      onClick: closePortal
    }, "Close portal"));
  }
  return (0, _react2.jsx)("div", null, (0, _react2.jsx)(_button.EuiButton, {
    onClick: togglePortal
  }, "View guide"), customPortal);
};
describe('EuiPortal', function () {
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(Portal, null));
    cy.get('div[data-relative-to-header="above"]').should('not.exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations after the portal is activated', function () {
      cy.get('button[type="button"]').contains('View guide').realClick();
      cy.get('div[data-euiportal="true"]').should('exist');
      cy.checkAxe();
    });
  });
});