"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPortalClass = exports.EuiPortal = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _services = require("../../services");
var _component_defaults = require("../provider/component_defaults");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /**
 * NOTE: We can't test this component because Enzyme doesn't support rendering
 * into portals.
 */
var INSERT_POSITIONS = ['after', 'before'];
var insertPositions = {
  after: 'afterend',
  before: 'beforebegin'
};
var EuiPortal = exports.EuiPortal = function EuiPortal(props) {
  var propsWithDefaults = (0, _component_defaults.usePropsWithComponentDefaults)('EuiPortal', props);
  return (0, _react2.jsx)(EuiPortalClass, propsWithDefaults);
};
var EuiPortalClass = exports.EuiPortalClass = /*#__PURE__*/function (_Component) {
  function EuiPortalClass(props) {
    var _this;
    (0, _classCallCheck2.default)(this, EuiPortalClass);
    _this = _callSuper(this, EuiPortalClass, [props]);
    _this.state = {
      portalNode: null
    };
    return _this;
  }
  (0, _inherits2.default)(EuiPortalClass, _Component);
  return (0, _createClass2.default)(EuiPortalClass, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var insert = this.props.insert;
      var portalNode = document.createElement('div');
      portalNode.dataset.euiportal = 'true';
      if (insert == null) {
        // no insertion defined, append to body
        document.body.appendChild(portalNode);
      } else {
        // inserting before or after an element
        var sibling = insert.sibling,
          position = insert.position;
        sibling.insertAdjacentElement(insertPositions[position], portalNode);
      }
      this.setThemeColor(portalNode);
      this.updatePortalRef(portalNode);

      // Update state with portalNode to intentionally trigger component rerender
      // and call createPortal with correct root element in render()
      this.setState({
        portalNode: portalNode
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var portalNode = this.state.portalNode;
      if (portalNode !== null && portalNode !== void 0 && portalNode.parentNode) {
        portalNode.parentNode.removeChild(portalNode);
      }
      this.updatePortalRef(null);
    }

    // Set the inherited color of the portal based on the wrapping EuiThemeProvider
  }, {
    key: "setThemeColor",
    value: function setThemeColor(portalNode) {
      if (this.context) {
        var _this$context = this.context,
          hasDifferentColorFromGlobalTheme = _this$context.hasDifferentColorFromGlobalTheme,
          colorClassName = _this$context.colorClassName;
        if (hasDifferentColorFromGlobalTheme && this.props.insert == null) {
          portalNode.classList.add(colorClassName);
        }
      }
    }
  }, {
    key: "updatePortalRef",
    value: function updatePortalRef(ref) {
      if (this.props.portalRef) {
        this.props.portalRef(ref);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var portalNode = this.state.portalNode;
      if (!portalNode) {
        return null;
      }
      return /*#__PURE__*/(0, _reactDom.createPortal)(this.props.children, portalNode);
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiPortalClass, "contextType", _services.EuiNestedThemeContext);