"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePropsWithComponentDefaults = exports.useComponentDefaults = exports.EuiComponentDefaultsProvider = exports.EuiComponentDefaultsContext = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Declaring as a static const for reference integrity/reducing rerenders
var emptyDefaults = {};

/*
 * Context
 */
var EuiComponentDefaultsContext = exports.EuiComponentDefaultsContext = /*#__PURE__*/(0, _react.createContext)(emptyDefaults);

/*
 * Component
 */

var EuiComponentDefaultsProvider = exports.EuiComponentDefaultsProvider = function EuiComponentDefaultsProvider(_ref) {
  var _ref$componentDefault = _ref.componentDefaults,
    componentDefaults = _ref$componentDefault === void 0 ? emptyDefaults : _ref$componentDefault,
    children = _ref.children;
  return (0, _react2.jsx)(EuiComponentDefaultsContext.Provider, {
    value: componentDefaults
  }, children);
};

/*
 * Hooks
 */
var useComponentDefaults = exports.useComponentDefaults = function useComponentDefaults() {
  return (0, _react.useContext)(EuiComponentDefaultsContext);
};

// Merge individual component props with component defaults
var usePropsWithComponentDefaults = exports.usePropsWithComponentDefaults = function usePropsWithComponentDefaults(componentName, props) {
  var _context$componentNam;
  var context = (0, _react.useContext)(EuiComponentDefaultsContext);
  var componentDefaults = (_context$componentNam = context[componentName]) !== null && _context$componentNam !== void 0 ? _context$componentNam : emptyDefaults;
  return (0, _react.useMemo)(function () {
    return _objectSpread(_objectSpread({}, componentDefaults), props);
  }, [componentDefaults, props]);
};