"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiResizableCollapseButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _button = require("../button");
var _screen_reader_only = require("../accessibility/screen_reader_only/screen_reader_only.styles");
var _resizable_collapse_button = require("./resizable_collapse_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "externalPosition", "internalPosition", "direction", "isVisible", "isCollapsed"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiResizableCollapseButton = exports.EuiResizableCollapseButton = function EuiResizableCollapseButton(_ref) {
  var className = _ref.className,
    _ref$externalPosition = _ref.externalPosition,
    externalPosition = _ref$externalPosition === void 0 ? 'before' : _ref$externalPosition,
    _ref$internalPosition = _ref.internalPosition,
    internalPosition = _ref$internalPosition === void 0 ? 'middle' : _ref$internalPosition,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'horizontal' : _ref$direction,
    isVisible = _ref.isVisible,
    isCollapsed = _ref.isCollapsed,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isHorizontal = direction === 'horizontal';
  var showOnFocus = !isCollapsed && !isVisible;
  var styles = (0, _services.useEuiMemoizedStyles)(_resizable_collapse_button.euiResizableCollapseButtonStyles);
  var collapsedStyles = [styles.collapsed.collapsed, styles.collapsed[direction], styles.collapsed["".concat(direction, "Positions")][internalPosition]];
  var collapsibleStyles = [styles.collapsible.collapsible, styles.collapsible[direction][externalPosition], styles.collapsible[direction][internalPosition]];
  var cssStyles = [styles.euiResizableCollapseButton, showOnFocus && _screen_reader_only.euiScreenReaderOnlyStyles['euiScreenReaderOnly-showOnFocus']].concat((0, _toConsumableArray2.default)(isCollapsed ? collapsedStyles : collapsibleStyles));
  var COLLAPSED_ICON = '';
  var NOT_COLLAPSED_ICON = '';
  switch (externalPosition) {
    case 'before':
      COLLAPSED_ICON = isHorizontal ? 'menuLeft' : 'menuUp';
      NOT_COLLAPSED_ICON = isHorizontal ? 'menuRight' : 'menuDown';
      break;
    case 'after':
      COLLAPSED_ICON = isHorizontal ? 'menuRight' : 'menuDown';
      NOT_COLLAPSED_ICON = isHorizontal ? 'menuLeft' : 'menuUp';
      break;
  }
  var classes = (0, _classnames.default)('euiResizableCollapseButton', className);
  return (0, _react2.jsx)(_button.EuiButtonIcon, (0, _extends2.default)({
    display: isCollapsed ? 'empty' : 'base',
    color: "text",
    className: classes,
    css: cssStyles
  }, rest, {
    iconType: isCollapsed ? COLLAPSED_ICON : NOT_COLLAPSED_ICON
  }));
};