"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiResizablePanelStyles = exports.euiResizablePanelContentStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiResizablePanelStyles = exports.euiResizablePanelStyles = {
  euiResizablePanel: process.env.NODE_ENV === "production" ? {
    name: "15ifdgc-euiResizablePanel",
    styles: "position:relative;label:euiResizablePanel;"
  } : {
    name: "15ifdgc-euiResizablePanel",
    styles: "position:relative;label:euiResizablePanel;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  },
  collapsed: process.env.NODE_ENV === "production" ? {
    name: "11qmbh3-collapsed",
    styles: "overflow:hidden;label:collapsed;"
  } : {
    name: "11qmbh3-collapsed",
    styles: "overflow:hidden;label:collapsed;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  }
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "597kt8-collapsedChildren",
  styles: "*{display:none;};label:collapsedChildren;"
} : {
  name: "597kt8-collapsedChildren",
  styles: "*{display:none;};label:collapsedChildren;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiResizablePanelContentStyles = exports.euiResizablePanelContentStyles = function euiResizablePanelContentStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiResizablePanel__content: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', '100%'), ";;label:euiResizablePanel__content;"),
    scrollable: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiScrollBarStyles)(euiThemeContext), " ", (0, _global_styling.logicalCSSWithFallback)('overflow-y', 'auto'), ";;label:scrollable;"),
    collapsedChildren: _ref,
    horizontal: {
      collapsed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-width', '0 !important'), ";;label:collapsed;"),
      hasCollapsibleButton: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-width', "".concat(euiTheme.size.l, " !important")), ";;label:hasCollapsibleButton;")
    },
    vertical: {
      collapsed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-height', '0 !important'), ";;label:collapsed;"),
      hasCollapsibleButton: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-height', "".concat(euiTheme.size.l, " !important")), ";;label:hasCollapsibleButton;")
    }
  };
};