"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.astToEsQueryDsl = exports._termValuesToQuery = exports._isFlagToQuery = exports._fieldValuesToQuery = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _predicate = require("../../../services/predicate");
var _common = require("../../common");
var _ast = require("./ast");
var _date_format = require("./date_format");
var _date_value = require("./date_value");
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var processDateOperation = function processDateOperation(value, operator) {
  var granularity = value.granularity,
    resolve = value.resolve;
  var expression = (0, _date_format.printIso8601)(resolve());
  if (!granularity) {
    return {
      operator: operator,
      expression: expression
    };
  }
  switch (operator) {
    case _ast.AST.Operator.GT:
      expression = "".concat(expression, "||+1").concat(granularity.es, "/").concat(granularity.es);
      return {
        operator: _ast.AST.Operator.GTE,
        expression: expression
      };
    case _ast.AST.Operator.GTE:
      expression = "".concat(expression, "||/").concat(granularity.es);
      return {
        operator: operator,
        expression: expression
      };
    case _ast.AST.Operator.LT:
      expression = "".concat(expression, "||/").concat(granularity.es);
      return {
        operator: operator,
        expression: expression
      };
    case _ast.AST.Operator.LTE:
      expression = "".concat(expression, "||+1").concat(granularity.es, "/").concat(granularity.es);
      return {
        operator: _ast.AST.Operator.LT,
        expression: expression
      };
    default:
      expression = "".concat(expression, "||/").concat(granularity.es);
      return {
        expression: expression
      };
  }
};
var _termValuesToQuery = exports._termValuesToQuery = function _termValuesToQuery(values, options) {
  var body = {
    query: values.map(function (value) {
      if ((0, _predicate.isString)(value) && value.match(/\s/)) {
        return "+\"".concat(value, "\"");
      }
      return "+".concat(value);
    }).join(' ')
  };
  if (body.query === '') {
    return;
  }
  if (options.defaultFields) {
    body.fields = options.defaultFields;
  }
  return {
    simple_query_string: body
  };
};
var _fieldValuesToQuery = exports._fieldValuesToQuery = function _fieldValuesToQuery(field, operations, andOr) {
  var queries = [];
  (0, _common.keysOf)(operations).forEach(function (operator) {
    var values = operations[operator];
    switch (operator) {
      case _ast.AST.Operator.EQ:
        var terms = [];
        var phrases = [];
        var dates = [];
        values.forEach(function (value) {
          if ((0, _date_value.isDateValue)(value)) {
            dates.push(value);
          } else if ((0, _predicate.isDateLike)(value)) {
            dates.push((0, _date_value.dateValue)(value));
          } else if ((0, _predicate.isString)(value) && value.match(/\s/)) {
            phrases.push(value);
          } else {
            terms.push(value);
          }
        });
        if (terms.length > 1) {
          queries.push({
            bool: (0, _defineProperty2.default)({}, andOr === 'and' ? 'must' : 'should', (0, _toConsumableArray2.default)(terms.map(function (value) {
              return {
                match: (0, _defineProperty2.default)({}, field, {
                  query: value,
                  operator: andOr
                })
              };
            })))
          });
        } else if (terms.length === 1) {
          queries.push({
            match: (0, _defineProperty2.default)({}, field, {
              query: terms[0],
              operator: andOr
            })
          });
        }
        if (phrases.length > 0) {
          queries.push.apply(queries, (0, _toConsumableArray2.default)(phrases.map(function (phrase) {
            return {
              match_phrase: (0, _defineProperty2.default)({}, field, phrase)
            };
          })));
        }
        if (dates.length > 0) {
          queries.push.apply(queries, (0, _toConsumableArray2.default)(dates.map(function (value) {
            return {
              match: (0, _defineProperty2.default)({}, field, processDateOperation(value).expression)
            };
          })));
        }
        break;
      default:
        values.forEach(function (value) {
          if ((0, _date_value.isDateValue)(value)) {
            var operation = processDateOperation(value, operator);
            queries.push({
              range: (0, _defineProperty2.default)({}, field, (0, _defineProperty2.default)({}, operation.operator, operation.expression))
            });
          } else {
            queries.push({
              range: (0, _defineProperty2.default)({}, field, (0, _defineProperty2.default)({}, operator, value))
            });
          }
        });
    }
  });
  if (queries.length === 1) {
    return queries[0];
  }
  var key = andOr === 'and' ? 'must' : 'should';
  return {
    bool: (0, _defineProperty2.default)({}, key, [].concat(queries))
  };
};
var _isFlagToQuery = exports._isFlagToQuery = function _isFlagToQuery(flag, on) {
  return {
    term: (0, _defineProperty2.default)({}, flag, on)
  };
};
var collectTerms = function collectTerms(clauses) {
  var values = {
    must: [],
    mustNot: []
  };
  var _iterator = _createForOfIteratorHelper(clauses),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var clause = _step.value;
      if (_ast.AST.Match.isMustClause(clause)) {
        values.must.push(clause.value);
      } else {
        values.mustNot.push(clause.value);
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  return values;
};
var collectFields = function collectFields(clauses) {
  var fieldArray = function fieldArray(obj, field, operator) {
    if (!obj[field]) {
      obj[field] = {};
    }
    if (!obj[field][operator]) {
      obj[field][operator] = [];
    }
    return obj[field][operator];
  };
  return clauses.reduce(function (fields, clause) {
    if (_ast.AST.Match.isMustClause(clause)) {
      if ((0, _predicate.isArray)(clause.value)) {
        var _fieldArray;
        (_fieldArray = fieldArray(fields.must.or, clause.field, clause.operator)).push.apply(_fieldArray, (0, _toConsumableArray2.default)(clause.value));
      } else {
        fieldArray(fields.must.and, clause.field, clause.operator).push(clause.value);
      }
    } else {
      if ((0, _predicate.isArray)(clause.value)) {
        var _fieldArray2;
        (_fieldArray2 = fieldArray(fields.mustNot.or, clause.field, clause.operator)).push.apply(_fieldArray2, (0, _toConsumableArray2.default)(clause.value));
      } else {
        fieldArray(fields.mustNot.and, clause.field, clause.operator).push(clause.value);
      }
    }
    return fields;
  }, {
    must: {
      and: {},
      or: {}
    },
    mustNot: {
      and: {},
      or: {}
    }
  });
};
var clausesToEsQueryDsl = function clausesToEsQueryDsl(_ref) {
  var fields = _ref.fields,
    terms = _ref.terms,
    is = _ref.is;
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var extraMustQueries = options.extraMustQueries || [];
  var extraMustNotQueries = options.extraMustNotQueries || [];
  var termValuesToQuery = options.termValuesToQuery || _termValuesToQuery;
  var fieldValuesToQuery = options.fieldValuesToQuery || _fieldValuesToQuery;
  var isFlagToQuery = options.isFlagToQuery || _isFlagToQuery;
  var must = [];
  must.push.apply(must, (0, _toConsumableArray2.default)(extraMustQueries));
  var termMustQuery = termValuesToQuery(terms.must, options);
  if (termMustQuery) {
    must.push(termMustQuery);
  }
  Object.keys(fields.must.and).forEach(function (field) {
    must.push(fieldValuesToQuery(field, fields.must.and[field], 'and'));
  });
  Object.keys(fields.must.or).forEach(function (field) {
    must.push(fieldValuesToQuery(field, fields.must.or[field], 'or'));
  });
  is.forEach(function (clause) {
    must.push(isFlagToQuery(clause.flag, _ast.AST.Match.isMustClause(clause)));
  });
  var mustNot = [];
  mustNot.push.apply(mustNot, (0, _toConsumableArray2.default)(extraMustNotQueries));
  var termMustNotQuery = termValuesToQuery(terms.mustNot, options);
  if (termMustNotQuery) {
    mustNot.push(termMustNotQuery);
  }
  Object.keys(fields.mustNot.and).forEach(function (field) {
    mustNot.push(fieldValuesToQuery(field, fields.mustNot.and[field], 'and'));
  });
  Object.keys(fields.mustNot.or).forEach(function (field) {
    mustNot.push(fieldValuesToQuery(field, fields.mustNot.or[field], 'or'));
  });
  var bool = {};
  if (must.length !== 0) {
    bool.must = must;
  }
  if (mustNot.length !== 0) {
    bool.must_not = mustNot;
  }
  return bool;
};
var EMPTY_TERMS = {
  must: [],
  mustNot: []
};
var EMPTY_FIELDS = {
  must: {
    and: {},
    or: {}
  },
  mustNot: {
    and: {},
    or: {}
  }
};
var astToEsQueryDsl = exports.astToEsQueryDsl = function astToEsQueryDsl(ast) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  if (ast.clauses.length === 0) {
    return {
      match_all: {}
    };
  }
  var terms = collectTerms(ast.getTermClauses());
  var fields = collectFields(ast.getFieldClauses());
  var is = ast.getIsClauses();
  var matchesBool = clausesToEsQueryDsl({
    terms: terms,
    fields: fields,
    is: is
  }, options);
  var hasTopMatches = Object.keys(matchesBool).length > 0;
  var groupClauses = ast.getGroupClauses();
  if (groupClauses.length === 0) {
    // there are no GroupClauses, everything at top level is combined as a must
    return {
      bool: matchesBool
    };
  } else {
    // there is at least one GroupClause, wrap the above clauses in another layer and append the ORs
    var must = groupClauses.reduce(function (must, groupClause) {
      var clauses = groupClause.value.reduce(function (clauses, clause) {
        if (_ast.AST.Term.isInstance(clause)) {
          clauses.push(clausesToEsQueryDsl({
            terms: collectTerms([clause]),
            fields: EMPTY_FIELDS,
            is: []
          }));
        } else if (_ast.AST.Field.isInstance(clause)) {
          clauses.push(clausesToEsQueryDsl({
            terms: EMPTY_TERMS,
            fields: collectFields([clause]),
            is: []
          }));
        } else if (_ast.AST.Is.isInstance(clause)) {
          clauses.push(clausesToEsQueryDsl({
            terms: EMPTY_TERMS,
            fields: EMPTY_FIELDS,
            is: [clause]
          }));
        }
        return clauses;
      }, []);
      must.push({
        bool: {
          should: clauses.map(function (clause) {
            return {
              bool: clause
            };
          })
        }
      });
      return must;
    }, hasTopMatches // only include the first match group if there are any conditions
    ? [{
      bool: matchesBool
    }] : []);
    return {
      bool: {
        must: must
      }
    };
  }
};