"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof3 = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Ast", {
  enumerable: true,
  get: function get() {
    return _query2.AST;
  }
});
exports.EuiSearchBar = void 0;
Object.defineProperty(exports, "Query", {
  enumerable: true,
  get: function get() {
    return _query2.Query;
  }
});
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _predicate = require("../../services/predicate");
var _flex = require("../flex");
var _search_box = require("./search_box");
var _search_filters = require("./search_filters");
var _query2 = require("./query");
var _search_bar = require("./search_bar.styles");
var _react2 = require("@emotion/react");
var _excluded = ["schema"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof3(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var parseQuery = function parseQuery(query, props) {
  var _props$box, _props$box2;
  var schema = undefined;
  if ((_props$box = props.box) !== null && _props$box !== void 0 && _props$box.schema && (0, _typeof2.default)((_props$box2 = props.box) === null || _props$box2 === void 0 ? void 0 : _props$box2.schema) === 'object') {
    schema = props.box.schema;
  }
  var dateFormat = props.dateFormat;
  var parseOptions = {
    schema: schema,
    dateFormat: dateFormat
  };
  if (!query) {
    return _query2.Query.parse('', parseOptions);
  }
  return (0, _predicate.isString)(query) ? _query2.Query.parse(query, parseOptions) : query;
};
var EuiSearchBar = exports.EuiSearchBar = /*#__PURE__*/function (_Component) {
  function EuiSearchBar(props) {
    var _this;
    (0, _classCallCheck2.default)(this, EuiSearchBar);
    _this = _callSuper(this, EuiSearchBar, [props]);
    (0, _defineProperty2.default)(_this, "hintId", (0, _services.htmlIdGenerator)('__hint')());
    (0, _defineProperty2.default)(_this, "onSearch", function (queryText) {
      try {
        var query = parseQuery(queryText, _this.props);
        _this.notifyControllingParent({
          query: query,
          queryText: queryText,
          error: null
        });
        _this.setState({
          query: query,
          queryText: queryText,
          error: null
        });
      } catch (e) {
        var error = e instanceof Error ? {
          name: e.name,
          message: e.message
        } : {
          name: 'Unexpected error',
          message: String(e)
        };
        _this.notifyControllingParent({
          query: null,
          queryText: queryText,
          error: error
        });
        _this.setState({
          queryText: queryText,
          error: error
        });
      }
    });
    (0, _defineProperty2.default)(_this, "onFiltersChange", function (query) {
      _this.notifyControllingParent({
        query: query,
        queryText: query.text,
        error: null
      });
      _this.setState({
        query: query,
        queryText: query.text,
        error: null
      });
    });
    var _query = parseQuery(props.defaultQuery || props.query, props);
    _this.state = {
      query: _query,
      queryText: _query.text,
      error: null,
      isHintVisible: false
    };
    return _this;
  }
  (0, _inherits2.default)(EuiSearchBar, _Component);
  return (0, _createClass2.default)(EuiSearchBar, [{
    key: "notifyControllingParent",
    value: function notifyControllingParent(newState) {
      var onChange = this.props.onChange;
      if (!onChange) {
        return;
      }
      var oldState = this.state;
      var query = newState.query,
        queryText = newState.queryText,
        error = newState.error;
      var isQueryDifferent = oldState.queryText !== queryText;
      var oldError = oldState.error ? oldState.error.message : null;
      var newError = error ? error.message : null;
      var isErrorDifferent = oldError !== newError;
      if (isQueryDifferent || isErrorDifferent) {
        if (error == null) {
          onChange({
            query: query,
            queryText: queryText,
            error: error
          });
        } else {
          onChange({
            query: null,
            queryText: queryText,
            error: error
          });
        }
      }
    }
  }, {
    key: "renderTools",
    value: function renderTools(tools) {
      if (!tools) {
        return undefined;
      }
      if (Array.isArray(tools)) {
        return tools.map(function (tool) {
          return (0, _react2.jsx)(_flex.EuiFlexItem, {
            grow: false,
            key: tool.key == null ? undefined : tool.key
          }, tool);
        });
      }
      return (0, _react2.jsx)(_flex.EuiFlexItem, {
        grow: false
      }, tools);
    }
  }, {
    key: "render",
    value: function render() {
      var _hint$popoverProps$is,
        _hint$popoverProps,
        _this2 = this;
      var _this$state = this.state,
        query = _this$state.query,
        queryText = _this$state.queryText,
        error = _this$state.error,
        isHintVisibleState = _this$state.isHintVisible;
      var _this$props = this.props,
        _this$props$box = _this$props.box,
        _this$props$box2 = _this$props$box === void 0 ? {
          schema: ''
        } : _this$props$box,
        schema = _this$props$box2.schema,
        box = (0, _objectWithoutProperties2.default)(_this$props$box2, _excluded),
        filters = _this$props.filters,
        toolsLeft = _this$props.toolsLeft,
        toolsRight = _this$props.toolsRight,
        hint = _this$props.hint;
      var toolsLeftEl = this.renderTools(toolsLeft);
      var toolsRightEl = this.renderTools(toolsRight);
      var isHintVisible = (_hint$popoverProps$is = hint === null || hint === void 0 || (_hint$popoverProps = hint.popoverProps) === null || _hint$popoverProps === void 0 ? void 0 : _hint$popoverProps.isOpen) !== null && _hint$popoverProps$is !== void 0 ? _hint$popoverProps$is : isHintVisibleState;
      return (0, _react2.jsx)(_services.RenderWithEuiTheme, null, function (euiTheme) {
        return (0, _react2.jsx)(_flex.EuiFlexGroup, {
          gutterSize: "m",
          alignItems: "center",
          wrap: true
        }, toolsLeftEl, (0, _react2.jsx)(_flex.EuiFlexItem, {
          className: "euiSearchBar__searchHolder",
          css: (0, _search_bar.euiSearchBar__searchHolder)(euiTheme),
          grow: true
        }, (0, _react2.jsx)(_search_box.EuiSearchBox, (0, _extends2.default)({}, box, {
          query: queryText,
          onSearch: _this2.onSearch,
          isInvalid: error != null,
          title: error ? error.message : undefined,
          "aria-describedby": isHintVisible ? "".concat(_this2.hintId) : undefined,
          hint: hint ? _objectSpread({
            isVisible: isHintVisible,
            setIsVisible: function setIsVisible(isVisible) {
              _this2.setState({
                isHintVisible: isVisible
              });
            },
            id: _this2.hintId
          }, hint) : undefined
        }))), filters && (0, _react2.jsx)(_flex.EuiFlexItem, {
          className: "euiSearchBar__filtersHolder",
          css: (0, _search_bar.euiSearchBar__filtersHolder)(euiTheme),
          grow: false
        }, (0, _react2.jsx)(_search_filters.EuiSearchBarFilters, {
          filters: filters,
          query: query,
          onChange: _this2.onFiltersChange
        })), toolsRightEl);
      });
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if ((nextProps.query || nextProps.query === '') && (!prevState.query || typeof nextProps.query !== 'string' && nextProps.query.text !== prevState.query.text || typeof nextProps.query === 'string' && nextProps.query !== prevState.query.text)) {
        var query = parseQuery(nextProps.query, nextProps);
        return {
          query: query,
          queryText: query.text,
          error: null,
          isHintVisible: prevState.isHintVisible
        };
      }
      return null;
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiSearchBar, "Query", _query2.Query);