"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PADDING_SIZES = exports.EuiSelectableListItem = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _icon = require("../../icon");
var _accessibility = require("../../accessibility");
var _badge = require("../../badge");
var _tool_tip = require("../../tool_tip");
var _selectable_list_item = require("./selectable_list_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "disabled", "checked", "isFocused", "showIcons", "prepend", "append", "allowExclusions", "onFocusBadge", "paddingSize", "role", "searchable", "textWrap", "toolTipContent", "toolTipProps", "aria-describedby"],
  _excluded2 = ["children", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function resolveIconAndColor(checked) {
  switch (checked) {
    case 'on':
      return {
        icon: 'check',
        color: 'text'
      };
    case 'off':
      return {
        icon: 'cross',
        color: 'text'
      };
    case 'mixed':
      return {
        icon: 'minus',
        color: 'text'
      };
    case undefined:
    default:
      return {
        icon: 'empty'
      };
  }
}
var PADDING_SIZES = exports.PADDING_SIZES = ['none', 's'];
var EuiSelectableListItem = exports.EuiSelectableListItem = function EuiSelectableListItem(_ref) {
  var children = _ref.children,
    className = _ref.className,
    disabled = _ref.disabled,
    checked = _ref.checked,
    isFocused = _ref.isFocused,
    _ref$showIcons = _ref.showIcons,
    showIcons = _ref$showIcons === void 0 ? true : _ref$showIcons,
    prepend = _ref.prepend,
    append = _ref.append,
    allowExclusions = _ref.allowExclusions,
    _ref$onFocusBadge = _ref.onFocusBadge,
    onFocusBadge = _ref$onFocusBadge === void 0 ? true : _ref$onFocusBadge,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 's' : _ref$paddingSize,
    _ref$role = _ref.role,
    role = _ref$role === void 0 ? 'option' : _ref$role,
    searchable = _ref.searchable,
    _ref$textWrap = _ref.textWrap,
    textWrap = _ref$textWrap === void 0 ? 'truncate' : _ref$textWrap,
    toolTipContent = _ref.toolTipContent,
    toolTipProps = _ref.toolTipProps,
    _ariaDescribedBy = _ref['aria-describedby'],
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiSelectableListItem', {
    'euiSelectableListItem-isFocused': isFocused
  }, className);
  var styles = (0, _services.useEuiMemoizedStyles)(_selectable_list_item.euiSelectableListItemStyles);
  var cssStyles = [styles.euiSelectableListItem, styles.padding[paddingSize]];
  var textStyles = [styles.euiSelectableListItem__text, styles.textWrap[textWrap]];
  var optionIcon = (0, _react.useMemo)(function () {
    if (showIcons) {
      var _resolveIconAndColor = resolveIconAndColor(checked),
        icon = _resolveIconAndColor.icon,
        color = _resolveIconAndColor.color;
      return (0, _react2.jsx)(_icon.EuiIcon, {
        css: styles.euiSelectableListItem__icon,
        className: "euiSelectableListItem__icon",
        color: color,
        type: icon
      });
    }
  }, [showIcons, checked, styles]);
  var prependNode = (0, _react.useMemo)(function () {
    if (prepend) {
      return (0, _react2.jsx)("span", {
        css: styles.euiSelectableListItem__prepend,
        className: "euiSelectableListItem__prepend"
      }, prepend);
    }
  }, [prepend, styles]);
  var onFocusBadgeNode = (0, _react.useMemo)(function () {
    var defaultOnFocusBadgeProps = {
      'aria-hidden': true,
      iconType: 'returnKey',
      iconSide: 'left',
      color: 'hollow'
    };
    if (onFocusBadge === true) {
      return (0, _react2.jsx)(_badge.EuiBadge, (0, _extends2.default)({
        className: "euiSelectableListItem__onFocusBadge"
      }, defaultOnFocusBadgeProps));
    } else if (typeof onFocusBadge !== 'boolean' && !!onFocusBadge) {
      var _children = onFocusBadge.children,
        _className = onFocusBadge.className,
        restBadgeProps = (0, _objectWithoutProperties2.default)(onFocusBadge, _excluded2);
      return (0, _react2.jsx)(_badge.EuiBadge, (0, _extends2.default)({
        className: (0, _classnames.default)('euiSelectableListItem__onFocusBadge', _className)
      }, defaultOnFocusBadgeProps, restBadgeProps), _children);
    }
  }, [onFocusBadge]);
  var showOnFocusBadge = !!(isFocused && !disabled && onFocusBadgeNode);
  var appendNode = (0, _react.useMemo)(function () {
    if (append || showOnFocusBadge) {
      return (0, _react2.jsx)("span", {
        css: styles.euiSelectableListItem__append,
        className: "euiSelectableListItem__append"
      }, append, " ", showOnFocusBadge ? onFocusBadgeNode : null);
    }
  }, [append, showOnFocusBadge, onFocusBadgeNode, styles]);
  var screenReaderText = (0, _react.useMemo)(function () {
    var state;
    var instructions;
    var screenReaderStrings = {
      checked: {
        state: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.checkedOption",
          default: "Checked option."
        }),
        instructions: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.checkOptionInstructions",
          default: "To check this option, press Enter."
        })
      },
      unchecked: {
        instructions: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.uncheckOptionInstructions",
          default: "To uncheck this option, press Enter."
        })
      },
      excluded: {
        state: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.excludedOption",
          default: "Excluded option."
        }),
        instructions: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.excludeOptionInstructions",
          default: "To exclude this option, press Enter."
        })
      },
      mixed: {
        state: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.mixedOption",
          default: "Mixed (indeterminate) option."
        }),
        instructions: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.mixedOptionInstructions",
          default: "To check this option for all, press Enter once."
        }),
        uncheckInstructions: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.mixedOptionUncheckInstructions",
          default: "To uncheck this option for all, press Enter twice."
        }),
        excludeInstructions: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.mixedOptionExcludeInstructions",
          default: "To exclude this option for all, press Enter twice."
        })
      }
    };
    switch (checked) {
      case 'on':
        state = screenReaderStrings.checked.state;
        instructions = allowExclusions ? screenReaderStrings.excluded.instructions : searchable ? screenReaderStrings.unchecked.instructions : undefined;
        break;
      case 'off':
        state = screenReaderStrings.excluded.state;
        instructions = screenReaderStrings.unchecked.instructions;
        break;
      case 'mixed':
        state = screenReaderStrings.mixed.state;
        instructions = (0, _react2.jsx)(_react.default.Fragment, null, screenReaderStrings.mixed.instructions, ' ', allowExclusions ? screenReaderStrings.mixed.excludeInstructions : screenReaderStrings.mixed.uncheckInstructions);
        break;
      case undefined:
      default:
        instructions = allowExclusions || searchable ? screenReaderStrings.checked.instructions : undefined;
        break;
    }
    return state || instructions ? (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("div", null, state || instructions ? '. ' : null, state, state && instructions ? ' ' : null, instructions)) : null;
  }, [checked, searchable, allowExclusions]);

  // aria-checked is intended to be used with role="checkbox" but
  // the MDN documentation lists it as a possibility for role="option".
  // See https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-checked
  // and https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/option_role
  var ariaChecked = (0, _react.useMemo)(function () {
    var rolesThatCanBeMixed = ['option', 'checkbox', 'menuitemcheckbox'];
    var rolesThatCanBeChecked = [].concat(rolesThatCanBeMixed, ['radio', 'menuitemradio', 'switch']);
    if (!rolesThatCanBeChecked.includes(role)) return undefined;
    switch (checked) {
      case 'on':
      case 'off':
        return true;
      case 'mixed':
        if (rolesThatCanBeMixed.includes(role)) {
          return 'mixed';
        } else {
          return false;
        }
      default:
        return false;
    }
  }, [role, checked]);
  var hasToolTip = !!toolTipContent && !disabled;
  var _useState = (0, _react.useState)(null),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    tooltipRef = _useState2[0],
    setTooltipRef = _useState2[1]; // Needs to be state and not a ref to trigger useEffect
  var _useState3 = (0, _react.useState)(_ariaDescribedBy),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    ariaDescribedBy = _useState4[0],
    setAriaDescribedBy = _useState4[1];

  // Manually trigger the tooltip on keyboard focus
  (0, _react.useEffect)(function () {
    if (!tooltipRef) return;
    if (isFocused) {
      tooltipRef.showToolTip();
    } else {
      tooltipRef.hideToolTip();
    }
  }, [isFocused, tooltipRef]);

  // Manually set the `aria-describedby` id on the <li> wrapper
  (0, _react.useEffect)(function () {
    if (tooltipRef) {
      var tooltipId = tooltipRef.state.id;
      setAriaDescribedBy((0, _classnames.default)(tooltipId, _ariaDescribedBy));
    }
  }, [tooltipRef, _ariaDescribedBy]);
  var content = (0, _react2.jsx)("span", {
    css: styles.euiSelectableListItem__content,
    className: "euiSelectableListItem__content"
  }, optionIcon, prependNode, (0, _react2.jsx)("span", {
    css: textStyles,
    className: "euiSelectableListItem__text"
  }, children, screenReaderText), appendNode);
  return (0, _react2.jsx)("li", (0, _extends2.default)({
    role: role,
    "aria-disabled": disabled,
    "aria-checked": ariaChecked // Whether the item is "checked"
    ,
    "aria-selected": !disabled && isFocused // Whether the item has keyboard focus per W3 spec
    ,
    css: cssStyles,
    className: classes
  }, rest, {
    "aria-describedby": ariaDescribedBy
  }), hasToolTip ? (0, _react2.jsx)(_tool_tip.EuiToolTip, (0, _extends2.default)({
    ref: setTooltipRef,
    content: toolTipContent,
    anchorClassName: "eui-fullWidth",
    position: "left"
  }, toolTipProps), content) : content);
};