"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSideNavItem = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _href_validator = require("../../services/security/href_validator");
var _inner_text = require("../inner_text");
var _icon = require("../icon");
var _side_nav_item = require("./side_nav_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["href", "target", "rel", "onClick", "className", "children", "disabled"],
  _excluded2 = ["isOpen", "isSelected", "isParent", "icon", "onClick", "href", "rel", "target", "items", "children", "renderItem", "depth", "className", "css", "style", "truncate", "emphasize", "buttonClassName", "childrenOnly"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * The props that are exposed to, or altered for, the consumer
 * for use in the object of items in `EuiSideNav`
 * can be found in the `side_nave_types.ts` file.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var DefaultRenderItem = function DefaultRenderItem(_ref) {
  var href = _ref.href,
    target = _ref.target,
    rel = _ref.rel,
    onClick = _ref.onClick,
    className = _ref.className,
    children = _ref.children,
    disabled = _ref.disabled,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  if (href && !disabled) {
    var secureRel = (0, _services.getSecureRelForTarget)({
      href: href,
      rel: rel,
      target: target
    });
    return (0, _react2.jsx)("a", (0, _extends2.default)({
      className: className,
      href: href,
      target: target,
      rel: secureRel,
      onClick: onClick
    }, rest), children);
  }
  if (onClick || disabled) {
    return (0, _react2.jsx)("button", (0, _extends2.default)({
      type: "button",
      className: className,
      onClick: onClick,
      disabled: disabled
    }, rest), children);
  }
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    className: className
  }, rest), children);
};
var EuiSideNavItem = exports.EuiSideNavItem = function EuiSideNavItem(_ref2) {
  var isOpen = _ref2.isOpen,
    isSelected = _ref2.isSelected,
    isParent = _ref2.isParent,
    icon = _ref2.icon,
    onClick = _ref2.onClick,
    _href = _ref2.href,
    rel = _ref2.rel,
    target = _ref2.target,
    items = _ref2.items,
    children = _ref2.children,
    _ref2$renderItem = _ref2.renderItem,
    RenderItem = _ref2$renderItem === void 0 ? DefaultRenderItem : _ref2$renderItem,
    _ref2$depth = _ref2.depth,
    depth = _ref2$depth === void 0 ? 0 : _ref2$depth,
    className = _ref2.className,
    css = _ref2.css,
    style = _ref2.style,
    _ref2$truncate = _ref2.truncate,
    truncate = _ref2$truncate === void 0 ? true : _ref2$truncate,
    emphasize = _ref2.emphasize,
    buttonClassName = _ref2.buttonClassName,
    childrenOnly = _ref2.childrenOnly,
    rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  var isHrefValid = !_href || (0, _href_validator.validateHref)(_href);
  var href = isHrefValid ? _href : '';

  // Forcing accordion style item if not linked, but has children
  var _useState = (0, _react.useState)(isOpen),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    itemIsOpen = _useState2[0],
    setItemIsOpen = _useState2[1];
  (0, _react.useEffect)(function () {
    setItemIsOpen(isOpen);
  }, [isOpen]);
  var toggleItemOpen = (0, _react.useCallback)(function () {
    setItemIsOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var isRoot = depth === 0;
  var isTrunk = depth === 1;
  var isBranch = depth > 1;
  var hasCaret = depth > 0 && childrenOnly;
  var hasChildItems = items && itemIsOpen;
  var classes = (0, _classnames.default)('euiSideNavItem', {
    'euiSideNavItem--root': isRoot,
    'euiSideNavItem--trunk': isTrunk,
    'euiSideNavItem--branch': isBranch,
    'euiSideNavItem--emphasized': emphasize,
    'euiSideNavItem-hasChildItems': hasChildItems
  }, className);
  var styles = (0, _services.useEuiMemoizedStyles)(_side_nav_item.euiSideNavItemStyles);
  var cssStyles = [styles.euiSideNavItem, isRoot && styles.root, isTrunk && styles.trunk, isBranch && styles.branch, emphasize && styles.emphasized, css];
  var itemsStyles = hasChildItems && [styles.items.euiSideNavItem__items, isRoot && icon && styles.items.rootWithIcon, isTrunk && styles.items.trunk, isBranch && styles.items.branch];
  var buttonClasses = (0, _classnames.default)('euiSideNavItemButton', {
    'euiSideNavItemButton-isOpen': depth > 0 && itemIsOpen && !isSelected,
    'euiSideNavItemButton-isSelected': isSelected
  }, buttonClassName);
  var buttonStyles = (0, _services.useEuiMemoizedStyles)(_side_nav_item.euiSideNavItemButtonStyles);
  var buttonCssStyles = [buttonStyles.euiSideNavItemButton, isSelected && buttonStyles.selected, emphasize && buttonStyles.emphasized, isRoot && buttonStyles.root, isTrunk && buttonStyles.trunk, isBranch && buttonStyles.branch];
  var labelCssStyles = [buttonStyles.label.euiSideNavItemButton__label, isRoot && buttonStyles.label.root];
  return (0, _react2.jsx)("div", {
    css: cssStyles,
    className: classes,
    style: style
  }, (0, _react2.jsx)(RenderItem, (0, _extends2.default)({
    css: buttonCssStyles,
    className: buttonClasses,
    href: href,
    rel: rel,
    target: target,
    onClick: childrenOnly ? toggleItemOpen : onClick
  }, rest), (0, _react2.jsx)("span", {
    css: buttonStyles.euiSideNavItemButton__content,
    className: "euiSideNavItemButton__content"
  }, icon, (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
    return (0, _react2.jsx)("span", {
      ref: ref,
      title: truncate ? innerText : undefined,
      css: labelCssStyles,
      className: (0, _classnames.default)('euiSideNavItemButton__label', {
        'eui-textTruncate': truncate
      })
    }, children);
  }), hasCaret && (0, _react2.jsx)(_icon.EuiIcon, {
    type: itemIsOpen ? 'arrowDown' : 'arrowRight',
    size: "s"
  }))), hasChildItems && (0, _react2.jsx)("div", {
    css: itemsStyles,
    className: "euiSideNavItem__items"
  }, items));
};