"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiSkeletonCircle = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _skeleton_loading = require("./skeleton_loading");
var _skeleton_circle = require("./skeleton_circle.styles");
var _react2 = require("@emotion/react");
var _excluded = ["isLoading", "size", "className", "contentAriaLabel", "announceLoadingStatus", "announceLoadedStatus", "ariaLiveProps", "ariaWrapperProps", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var SIZES = exports.SIZES = ['s', 'm', 'l', 'xl'];
var EuiSkeletonCircle = exports.EuiSkeletonCircle = function EuiSkeletonCircle(_ref) {
  var _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? true : _ref$isLoading,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    className = _ref.className,
    contentAriaLabel = _ref.contentAriaLabel,
    announceLoadingStatus = _ref.announceLoadingStatus,
    announceLoadedStatus = _ref.announceLoadedStatus,
    ariaLiveProps = _ref.ariaLiveProps,
    ariaWrapperProps = _ref.ariaWrapperProps,
    children = _ref.children,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_skeleton_circle.euiSkeletonCircleStyles);
  var cssStyles = [styles.euiSkeletonCircle, styles[size]];
  return (0, _react2.jsx)(_skeleton_loading.EuiSkeletonLoading, (0, _extends2.default)({
    isLoading: isLoading,
    loadingContent: (0, _react2.jsx)("div", (0, _extends2.default)({
      className: (0, _classnames.default)('euiSkeletonCircle', className),
      css: cssStyles
    }, rest)),
    loadedContent: children || '',
    contentAriaLabel: contentAriaLabel,
    announceLoadingStatus: announceLoadingStatus,
    announceLoadedStatus: announceLoadedStatus,
    ariaLiveProps: ariaLiveProps
  }, ariaWrapperProps));
};