"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSkeletonLoading = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _screen_reader_live = require("../accessibility/screen_reader_live");
var _i18n = require("../i18n");
var _react2 = require("@emotion/react");
var _excluded = ["isLoading", "contentAriaLabel", "loadingContent", "loadedContent", "announceLoadingStatus", "announceLoadedStatus", "ariaLiveProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiSkeletonLoading = exports.EuiSkeletonLoading = function EuiSkeletonLoading(_ref) {
  var _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? true : _ref$isLoading,
    contentAriaLabel = _ref.contentAriaLabel,
    _loadingContent = _ref.loadingContent,
    loadedContent = _ref.loadedContent,
    _ref$announceLoadingS = _ref.announceLoadingStatus,
    announceLoadingStatus = _ref$announceLoadingS === void 0 ? false : _ref$announceLoadingS,
    _ref$announceLoadedSt = _ref.announceLoadedStatus,
    announceLoadedStatus = _ref$announceLoadedSt === void 0 ? true : _ref$announceLoadedSt,
    ariaLiveProps = _ref.ariaLiveProps,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var loadedAriaLive = (0, _i18n.useEuiI18n)('euiSkeletonLoading.loadedAriaText', 'Loaded {contentAriaLabel}', {
    contentAriaLabel: contentAriaLabel
  });
  var loadingAriaLabel = (0, _i18n.useEuiI18n)('euiSkeletonLoading.loadingAriaText', 'Loading {contentAriaLabel}', {
    contentAriaLabel: contentAriaLabel
  });
  var loadingProps = {
    'aria-label': loadingAriaLabel,
    role: 'progressbar'
  };
  var loadingContent = /*#__PURE__*/_react.default.cloneElement(_loadingContent, loadingProps);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    "aria-busy": isLoading,
    "data-test-subj": "euiSkeletonLoadingAriaWrapper"
  }, rest), isLoading ? (0, _react2.jsx)(_react.default.Fragment, null, announceLoadingStatus && (0, _react2.jsx)(_screen_reader_live.EuiScreenReaderLive, ariaLiveProps, loadingAriaLabel), loadingContent) : (0, _react2.jsx)(_react.default.Fragment, null, announceLoadedStatus && (0, _react2.jsx)(_screen_reader_live.EuiScreenReaderLive, ariaLiveProps, loadedAriaLive), loadedContent));
};