"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RADIUS = exports.EuiSkeletonRectangle = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _skeleton_loading = require("./skeleton_loading");
var _skeleton_rectangle = require("./skeleton_rectangle.styles");
var _react2 = require("@emotion/react");
var _excluded = ["isLoading", "borderRadius", "width", "height", "style", "className", "contentAriaLabel", "announceLoadingStatus", "announceLoadedStatus", "ariaLiveProps", "ariaWrapperProps", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var RADIUS = exports.RADIUS = ['s', 'm', 'none'];
var EuiSkeletonRectangle = exports.EuiSkeletonRectangle = function EuiSkeletonRectangle(_ref) {
  var _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? true : _ref$isLoading,
    _ref$borderRadius = _ref.borderRadius,
    borderRadius = _ref$borderRadius === void 0 ? 's' : _ref$borderRadius,
    _ref$width = _ref.width,
    width = _ref$width === void 0 ? '24px' : _ref$width,
    _ref$height = _ref.height,
    height = _ref$height === void 0 ? '24px' : _ref$height,
    style = _ref.style,
    className = _ref.className,
    contentAriaLabel = _ref.contentAriaLabel,
    announceLoadingStatus = _ref.announceLoadingStatus,
    announceLoadedStatus = _ref.announceLoadedStatus,
    ariaLiveProps = _ref.ariaLiveProps,
    ariaWrapperProps = _ref.ariaWrapperProps,
    children = _ref.children,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_skeleton_rectangle.euiSkeletonRectangleStyles);
  var cssStyles = [styles.euiSkeletonRectangle, styles[borderRadius]];
  return (0, _react2.jsx)(_skeleton_loading.EuiSkeletonLoading, (0, _extends2.default)({
    isLoading: isLoading,
    loadingContent: (0, _react2.jsx)("div", (0, _extends2.default)({
      className: (0, _classnames.default)('euiSkeletonRectangle', className),
      css: cssStyles,
      style: (0, _global_styling.logicalStyles)(_objectSpread(_objectSpread({}, style), {}, {
        width: width,
        height: height
      }))
    }, rest)),
    loadedContent: children || '',
    contentAriaLabel: contentAriaLabel,
    announceLoadingStatus: announceLoadingStatus,
    announceLoadedStatus: announceLoadedStatus,
    ariaLiveProps: ariaLiveProps
  }, ariaWrapperProps));
};