"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSkeletonTextStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var calculateLineSize = function calculateLineSize(euiThemeContext, size) {
  var _euiFontSize = (0, _global_styling.euiFontSize)(euiThemeContext, 'm', {
      customScale: size
    }),
    fontSize = _euiFontSize.fontSize,
    lineHeight = _euiFontSize.lineHeight;
  return "\n    ".concat((0, _global_styling.logicalCSS)('height', fontSize), "\n    ").concat((0, _global_styling.logicalCSS)('margin-top', (0, _global_styling.mathWithUnits)([lineHeight, fontSize], function (x, y) {
    return x - y;
  })), "\n  ");
};
var euiSkeletonTextStyles = exports.euiSkeletonTextStyles = function euiSkeletonTextStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiSkeletonText: /*#__PURE__*/(0, _react.css)("display:block;", (0, _global_styling.logicalCSS)('width', '100%'), " border-radius:", euiTheme.border.radius.small, ";", (0, _utils.euiSkeletonGradientAnimation)(euiThemeContext), "transform:translateY(-25%);&:last-child:not(:only-child){", (0, _global_styling.logicalCSS)('width', '75%'), ";};label:euiSkeletonText;"),
    // Sizes
    m: /*#__PURE__*/(0, _react.css)(calculateLineSize(euiThemeContext, 'm'), ";;label:m;"),
    s: /*#__PURE__*/(0, _react.css)(calculateLineSize(euiThemeContext, 's'), ";;label:s;"),
    xs: /*#__PURE__*/(0, _react.css)(calculateLineSize(euiThemeContext, 'xs'), ";;label:xs;"),
    relative: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', '1em'), " ", (0, _global_styling.logicalCSS)('margin-top', '0.5em'), ";;label:relative;")
  };
};