"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STATUS = exports.EuiStepNumber = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
var _accessibility = require("../accessibility");
var _icon = require("../icon");
var _loading = require("../loading");
var _services = require("../../services");
var _step_strings = require("./step_strings");
var _step_number = require("./step_number.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "status", "number", "titleSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var STATUS = exports.STATUS = ['incomplete', 'disabled', 'loading', 'warning', 'danger', 'complete', 'current'];
var EuiStepNumber = exports.EuiStepNumber = function EuiStepNumber(_ref) {
  var className = _ref.className,
    status = _ref.status,
    number = _ref.number,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 's' : _ref$titleSize,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var ariaLabelsMap = {
    step: (0, _step_strings.useI18nStep)({
      number: number
    }),
    current: (0, _step_strings.useI18nCurrentStep)({
      number: number
    }),
    incomplete: (0, _step_strings.useI18nIncompleteStep)({
      number: number
    }),
    complete: (0, _step_strings.useI18nCompleteStep)({
      number: number
    }),
    disabled: (0, _step_strings.useI18nDisabledStep)({
      number: number
    }),
    warning: (0, _step_strings.useI18nWarningStep)({
      number: number
    }),
    danger: (0, _step_strings.useI18nErrorsStep)({
      number: number
    }),
    loading: (0, _step_strings.useI18nLoadingStep)({
      number: number
    })
  };
  var classes = (0, _classnames.default)('euiStepNumber', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _step_number.euiStepNumberStyles)(euiTheme);
  var cssStyles = [styles.euiStepNumber, styles[titleSize], status && styles[status]];
  var contentStyles = (0, _step_number.euiStepNumberContentStyles)(euiTheme);
  var content;
  var screenReaderText;
  switch (status) {
    // Loading spinner
    case 'loading':
      {
        var iconSizeMap = {
          none: 'm',
          xs: 'l',
          s: 'xl',
          m: 'xl'
        };
        screenReaderText = ariaLabelsMap.loading;
        content = (0, _react2.jsx)(_loading.EuiLoadingSpinner, {
          className: "euiStepNumber__loader",
          size: iconSizeMap[titleSize]
        });
        break;
      }
    // Statuses with icons
    case 'danger':
    case 'warning':
    case 'complete':
      {
        var cssIconStyles = [contentStyles.euiStepNumber__icon, contentStyles[status],
        // EuiIcon does not support a xxs size so far,
        // we use custom sizing here instead
        titleSize === 'none' && contentStyles[titleSize]];
        var iconTypeMap = {
          danger: 'cross',
          warning: 'warning',
          complete: 'check'
        };
        var _iconSizeMap = {
          xxs: 's',
          xs: 's',
          s: 'm',
          m: 'm'
        };
        content = (0, _react2.jsx)(_icon.EuiIcon, {
          type: iconTypeMap[status],
          "aria-label": ariaLabelsMap[status],
          size: _iconSizeMap[titleSize],
          className: "euiStepNumber__icon",
          css: cssIconStyles
        });
        break;
      }
    // Statuses with numbers
    case 'incomplete':
    case 'current':
    case 'disabled':
    default:
      screenReaderText = ariaLabelsMap[status || 'step'];
      if (titleSize === 'none') {
        break;
      }
      var cssNumberStyles = [contentStyles.euiStepNumber__number, status && contentStyles[status]];
      content = (0, _react2.jsx)("span", {
        "aria-hidden": "true",
        className: "euiStepNumber__number",
        css: cssNumberStyles
      }, number);
      break;
  }
  return (0, _react2.jsx)("span", (0, _extends2.default)({
    className: classes,
    css: cssStyles
  }, rest), screenReaderText && (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, screenReaderText)), content);
};