"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableCellContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _predicate = require("../../services/predicate");
var _text_truncate = require("../text_truncate");
var _responsive_context = require("./mobile/responsive_context");
var _table_cell_content = require("./_table_cell_content.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "align", "textOnly", "truncateText", "hasActions"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiTableCellContent = exports.EuiTableCellContent = function EuiTableCellContent(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$align = _ref.align,
    align = _ref$align === void 0 ? _services.LEFT_ALIGNMENT : _ref$align,
    textOnly = _ref.textOnly,
    _ref$truncateText = _ref.truncateText,
    truncateText = _ref$truncateText === void 0 ? false : _ref$truncateText,
    hasActions = _ref.hasActions,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isResponsive = (0, _responsive_context.useEuiTableIsResponsive)();
  var styles = (0, _services.useEuiMemoizedStyles)(_table_cell_content.euiTableCellContentStyles);
  var cssStyles = [styles.euiTableCellContent, styles[align], truncateText === true && styles.truncateText, truncateText === false && styles.wrapText].concat((0, _toConsumableArray2.default)(hasActions ? [styles.hasActions.actions, !isResponsive && styles.hasActions.desktop, isResponsive && hasActions !== 'custom' && styles.hasActions.mobile] : []));
  var classes = (0, _classnames.default)('euiTableCellContent', className);
  var renderedChildren = (0, _react.useMemo)(function () {
    var textClasses = 'euiTableCellContent__text';
    if ((0, _predicate.isObject)(truncateText) && truncateText.lines) {
      return (0, _react2.jsx)(_text_truncate.EuiTextBlockTruncate, {
        lines: truncateText.lines,
        cloneElement: true
      }, (0, _react2.jsx)("span", {
        className: textClasses
      }, children));
    }
    if (textOnly === true || truncateText === true) {
      return (0, _react2.jsx)("span", {
        className: textClasses
      }, children);
    }
    return children;
  }, [children, textOnly, truncateText]);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest), renderedChildren);
};