"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _responsive_context = require("./mobile/responsive_context");
var _table = require("./table.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "compressed", "tableLayout", "responsiveBreakpoint"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiTable = exports.EuiTable = function EuiTable(_ref) {
  var children = _ref.children,
    className = _ref.className,
    compressed = _ref.compressed,
    _ref$tableLayout = _ref.tableLayout,
    tableLayout = _ref$tableLayout === void 0 ? 'fixed' : _ref$tableLayout,
    responsiveBreakpoint = _ref.responsiveBreakpoint,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isResponsive = (0, _responsive_context.useIsEuiTableResponsive)(responsiveBreakpoint);
  var classes = (0, _classnames.default)('euiTable', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_table.euiTableStyles);
  var cssStyles = [styles.euiTable, styles.layout[tableLayout], (!compressed || isResponsive) && styles.uncompressed, compressed && !isResponsive && styles.compressed, isResponsive ? styles.mobile : styles.desktop];
  return (0, _react2.jsx)("table", (0, _extends2.default)({
    tabIndex: -1,
    css: cssStyles,
    className: classes
  }, rest), (0, _react2.jsx)(_responsive_context.EuiTableIsResponsiveContext.Provider, {
    value: isResponsive
  }, children));
};