"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableHeaderCell = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _accessibility = require("../accessibility");
var _icon = require("../icon");
var _inner_text = require("../inner_text");
var _utils = require("./utils");
var _responsive_context = require("./mobile/responsive_context");
var _table_cell_content = require("./_table_cell_content");
var _table_cells_shared = require("./table_cells_shared.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "align", "onSort", "isSorted", "isSortAscending", "className", "scope", "mobileOptions", "width", "style", "readOnly", "description", "append"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var CellContents = function CellContents(_ref) {
  var className = _ref.className,
    align = _ref.align,
    description = _ref.description,
    children = _ref.children,
    canSort = _ref.canSort,
    isSorted = _ref.isSorted,
    isSortAscending = _ref.isSortAscending;
  return (0, _react2.jsx)(_table_cell_content.EuiTableCellContent, {
    className: className,
    align: align,
    textOnly: false,
    truncateText: null
  }, (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
    return (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiTableHeaderCell.titleTextWithDesc",
      default: "{innerText}; {description}",
      values: {
        innerText: innerText,
        description: description
      }
    }, function (titleTextWithDesc) {
      return (0, _react2.jsx)("span", {
        title: description ? titleTextWithDesc : innerText,
        ref: ref,
        className: "eui-textTruncate"
      }, children);
    });
  }), description && (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, description)), isSorted ? (0, _react2.jsx)(_icon.EuiIcon, {
    className: "euiTableSortIcon",
    type: isSortAscending ? 'sortUp' : 'sortDown',
    size: "m"
  }) : canSort ? (0, _react2.jsx)(_icon.EuiIcon, {
    className: "euiTableSortIcon euiTableSortIcon--sortable",
    type: "sortable",
    size: "m",
    color: "subdued" // Tinted a bit further via CSS
  }) : null);
};
var EuiTableHeaderCell = exports.EuiTableHeaderCell = function EuiTableHeaderCell(_ref2) {
  var children = _ref2.children,
    _ref2$align = _ref2.align,
    align = _ref2$align === void 0 ? _services.LEFT_ALIGNMENT : _ref2$align,
    onSort = _ref2.onSort,
    isSorted = _ref2.isSorted,
    isSortAscending = _ref2.isSortAscending,
    className = _ref2.className,
    scope = _ref2.scope,
    mobileOptions = _ref2.mobileOptions,
    width = _ref2.width,
    style = _ref2.style,
    readOnly = _ref2.readOnly,
    description = _ref2.description,
    append = _ref2.append,
    rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_table_cells_shared.euiTableHeaderFooterCellStyles);
  var isResponsive = (0, _responsive_context.useEuiTableIsResponsive)();
  var hideForDesktop = !isResponsive && (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.only);
  var hideForMobile = isResponsive && (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.show) === false;
  if (hideForDesktop || hideForMobile) return null;
  var classes = (0, _classnames.default)('euiTableHeaderCell', className);
  var inlineStyles = (0, _utils.resolveWidthAsStyle)(style, width);
  var CellComponent = children ? 'th' : 'td';
  var cellScope = CellComponent === 'th' ? scope !== null && scope !== void 0 ? scope : 'col' : undefined; // `scope` is only valid on `th` elements

  var canSort = !!(onSort && !readOnly);
  var ariaSortValue;
  if (isSorted) {
    ariaSortValue = isSortAscending ? 'ascending' : 'descending';
  } else if (canSort) {
    ariaSortValue = 'none';
  }
  var cellContentsProps = {
    css: styles.euiTableHeaderCell__content,
    align: align,
    description: description,
    canSort: canSort,
    isSorted: isSorted,
    isSortAscending: isSortAscending,
    children: children
  };
  return (0, _react2.jsx)(CellComponent, (0, _extends2.default)({
    css: styles.euiTableHeaderCell,
    className: classes,
    scope: cellScope,
    role: "columnheader",
    "aria-sort": ariaSortValue,
    style: inlineStyles
  }, rest), canSort ? (0, _react2.jsx)("button", {
    type: "button",
    css: styles.euiTableHeaderCell__button,
    className: (0, _classnames.default)('euiTableHeaderButton', {
      'euiTableHeaderButton-isSorted': isSorted
    }),
    onClick: onSort,
    "data-test-subj": "tableHeaderSortButton"
  }, (0, _react2.jsx)(CellContents, cellContentsProps)) : (0, _react2.jsx)(CellContents, cellContentsProps), append);
};