"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTablePagination = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _button = require("../../button");
var _context_menu = require("../../context_menu");
var _flex = require("../../flex");
var _pagination = require("../../pagination");
var _popover = require("../../popover");
var _i18n = require("../../i18n");
var _component_defaults = require("../../provider/component_defaults");
var _table_pagination_defaults = require("./table_pagination_defaults");
var _react2 = require("@emotion/react");
var _excluded = ["activePage", "itemsPerPage", "itemsPerPageOptions", "showPerPageOptions", "onChangeItemsPerPage", "onChangePage", "pageCount"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiTablePagination = exports.EuiTablePagination = function EuiTablePagination(props) {
  var _usePropsWithComponen = (0, _component_defaults.usePropsWithComponentDefaults)('EuiTablePagination', props),
    activePage = _usePropsWithComponen.activePage,
    _usePropsWithComponen2 = _usePropsWithComponen.itemsPerPage,
    itemsPerPage = _usePropsWithComponen2 === void 0 ? _table_pagination_defaults.euiTablePaginationDefaults.itemsPerPage : _usePropsWithComponen2,
    _usePropsWithComponen3 = _usePropsWithComponen.itemsPerPageOptions,
    itemsPerPageOptions = _usePropsWithComponen3 === void 0 ? _table_pagination_defaults.euiTablePaginationDefaults.itemsPerPageOptions : _usePropsWithComponen3,
    _usePropsWithComponen4 = _usePropsWithComponen.showPerPageOptions,
    showPerPageOptions = _usePropsWithComponen4 === void 0 ? _table_pagination_defaults.euiTablePaginationDefaults.showPerPageOptions : _usePropsWithComponen4,
    onChangeItemsPerPage = _usePropsWithComponen.onChangeItemsPerPage,
    onChangePage = _usePropsWithComponen.onChangePage,
    pageCount = _usePropsWithComponen.pageCount,
    rest = (0, _objectWithoutProperties2.default)(_usePropsWithComponen, _excluded);
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var togglePopover = (0, _react.useCallback)(function () {
    setIsPopoverOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var closePopover = (0, _react.useCallback)(function () {
    setIsPopoverOpen(false);
  }, []);
  var button = (0, _react2.jsx)(_button.EuiButtonEmpty, {
    size: "xs",
    color: "text",
    iconType: "arrowDown",
    iconSide: "right",
    "data-test-subj": "tablePaginationPopoverButton",
    onClick: togglePopover
  }, itemsPerPage === 0 ? (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiTablePagination.allRows",
    default: "Showing all rows"
  }) : (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiTablePagination.rowsPerPage",
    default: "Rows per page"
  }), ": ", itemsPerPage));
  var items = (0, _react.useMemo)(function () {
    return itemsPerPageOptions.map(function (itemsPerPageOption) {
      return (0, _react2.jsx)(_context_menu.EuiContextMenuItem, {
        key: itemsPerPageOption,
        icon: itemsPerPageOption === itemsPerPage ? 'check' : 'empty',
        "aria-current": itemsPerPageOption === itemsPerPage ? 'true' : undefined,
        onClick: function onClick() {
          closePopover();
          onChangeItemsPerPage === null || onChangeItemsPerPage === void 0 || onChangeItemsPerPage(itemsPerPageOption);
        },
        "data-test-subj": "tablePagination-".concat(itemsPerPageOption, "-rows")
      }, itemsPerPageOption === 0 ? (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiTablePagination.rowsPerPageOptionShowAllRows",
        default: "Show all rows"
      }) : (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiTablePagination.rowsPerPageOption",
        values: {
          rowsPerPage: itemsPerPageOption
        },
        default: "{rowsPerPage} rows"
      }));
    });
  }, [itemsPerPageOptions, itemsPerPage, onChangeItemsPerPage, closePopover]);
  var itemsPerPagePopover = (0, _react2.jsx)(_popover.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "upRight"
  }, (0, _react2.jsx)(_context_menu.EuiContextMenuPanel, {
    items: items,
    "data-test-subj": "tablePaginationRowOptions"
  }));
  return (0, _react2.jsx)(_flex.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false,
    wrap: true,
    gutterSize: "s",
    className: "eui-xScroll"
  }, (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, showPerPageOptions && itemsPerPagePopover), (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, itemsPerPage > 0 && (0, _react2.jsx)(_pagination.EuiPagination, (0, _extends2.default)({
    pageCount: pageCount,
    activePage: activePage,
    onPageClick: onChangePage
  }, rest))));
};