"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableRowCell = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _responsive_context = require("./mobile/responsive_context");
var _utils = require("./utils");
var _table_cell_content = require("./_table_cell_content");
var _table_row_cell = require("./table_row_cell.styles");
var _react2 = require("@emotion/react");
var _excluded = ["align", "children", "className", "truncateText", "setScopeRow", "textOnly", "hasActions", "isExpander", "style", "width", "valign", "mobileOptions", "append"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiTableRowCell = exports.EuiTableRowCell = function EuiTableRowCell(_ref) {
  var _ref$align = _ref.align,
    align = _ref$align === void 0 ? _services.LEFT_ALIGNMENT : _ref$align,
    children = _ref.children,
    className = _ref.className,
    truncateText = _ref.truncateText,
    setScopeRow = _ref.setScopeRow,
    _ref$textOnly = _ref.textOnly,
    textOnly = _ref$textOnly === void 0 ? true : _ref$textOnly,
    hasActions = _ref.hasActions,
    isExpander = _ref.isExpander,
    style = _ref.style,
    width = _ref.width,
    _ref$valign = _ref.valign,
    valign = _ref$valign === void 0 ? 'middle' : _ref$valign,
    mobileOptions = _ref.mobileOptions,
    append = _ref.append,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isResponsive = (0, _responsive_context.useEuiTableIsResponsive)();
  var styles = (0, _services.useEuiMemoizedStyles)(_table_row_cell.euiTableRowCellStyles);
  var cssStyles = [styles.euiTableRowCell, setScopeRow && styles.rowHeader, isExpander && styles.isExpander, hasActions && styles.hasActions, styles[valign]].concat((0, _toConsumableArray2.default)(isResponsive ? [styles.mobile.mobile, (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.enlarge) && styles.mobile.enlarge, hasActions === 'custom' && styles.mobile.customActions, hasActions === true && styles.mobile.actions, isExpander && styles.mobile.expander] : [styles.desktop.desktop, hasActions && styles.desktop.actions]));
  var cellClasses = (0, _classnames.default)('euiTableRowCell', className, {
    'euiTableRowCell--hasActions': hasActions,
    'euiTableRowCell--isExpander': isExpander
  });
  var widthValue = isResponsive ? hasActions || isExpander ? undefined // On mobile, actions are shifted to a right column via CSS
  : mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.width : width;
  var styleObj = (0, _utils.resolveWidthAsStyle)(style, widthValue);
  var Element = setScopeRow ? 'th' : 'td';
  var sharedProps = _objectSpread({
    scope: setScopeRow ? 'row' : undefined,
    style: styleObj,
    css: cssStyles
  }, rest);
  var sharedContentProps = {
    align: align,
    textOnly: textOnly,
    truncateText: truncateText,
    hasActions: hasActions || isExpander
  };
  if (isResponsive) {
    // Mobile view
    if ((mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.show) === false) {
      return null;
    } else {
      var _mobileOptions$align, _mobileOptions$trunca, _mobileOptions$textOn;
      return (0, _react2.jsx)(Element, (0, _extends2.default)({
        className: cellClasses
      }, sharedProps), (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.header) && (0, _react2.jsx)("div", {
        className: "euiTableRowCell__mobileHeader",
        css: styles.euiTableRowCell__mobileHeader
      }, mobileOptions.header), (0, _react2.jsx)(_table_cell_content.EuiTableCellContent, (0, _extends2.default)({}, sharedContentProps, {
        align: (_mobileOptions$align = mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.align) !== null && _mobileOptions$align !== void 0 ? _mobileOptions$align : 'left' // Default to left aligned mobile cells, unless consumers specifically set an alignment for mobile
        ,
        truncateText: (_mobileOptions$trunca = mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.truncateText) !== null && _mobileOptions$trunca !== void 0 ? _mobileOptions$trunca : truncateText,
        textOnly: (_mobileOptions$textOn = mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.textOnly) !== null && _mobileOptions$textOn !== void 0 ? _mobileOptions$textOn : textOnly
      }), (mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.render) || children), append);
    }
  } else {
    // Desktop view
    if (mobileOptions !== null && mobileOptions !== void 0 && mobileOptions.only) {
      return null;
    } else {
      return (0, _react2.jsx)(Element, (0, _extends2.default)({
        className: cellClasses
      }, sharedProps), (0, _react2.jsx)(_table_cell_content.EuiTableCellContent, sharedContentProps, children), append);
    }
  }
};