"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiTableRowCellStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _table = require("./table.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1amvdy6-bottom",
  styles: "vertical-align:bottom;label:bottom;"
} : {
  name: "1amvdy6-bottom",
  styles: "vertical-align:bottom;label:bottom;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "2f764e-top",
  styles: "vertical-align:top;label:top;"
} : {
  name: "2f764e-top",
  styles: "vertical-align:top;label:top;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "19hexhy-baseline",
  styles: "vertical-align:baseline;label:baseline;"
} : {
  name: "19hexhy-baseline",
  styles: "vertical-align:baseline;label:baseline;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "l1nme7-middle",
  styles: "vertical-align:middle;label:middle;"
} : {
  name: "l1nme7-middle",
  styles: "vertical-align:middle;label:middle;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiTableRowCellStyles = exports.euiTableRowCellStyles = function euiTableRowCellStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiTableVariables = (0, _table.euiTableVariables)(euiThemeContext),
    mobileSizes = _euiTableVariables.mobileSizes;

  // Unsets the extra strut caused by inline-block display of buttons/icons/tooltips.
  // Without this, the row height jumps whenever actions are disabled.
  var hasIcons = "line-height: 1;";
  return {
    euiTableRowCell: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.text, ";;label:euiTableRowCell;"),
    rowHeader: /*#__PURE__*/(0, _react.css)("font-weight:", euiTheme.font.weight.regular, ";", (0, _global_styling.logicalTextAlignCSS)('left'), ";;label:rowHeader;"),
    isExpander: /*#__PURE__*/(0, _react.css)(hasIcons, ";;label:isExpander;"),
    hasActions: /*#__PURE__*/(0, _react.css)(hasIcons, ";;label:hasActions;"),
    // valign
    middle: _ref4,
    baseline: _ref3,
    top: _ref2,
    bottom: _ref,
    desktop: {
      desktop: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-vertical', euiTheme.border.thin), ";;label:desktop;"),
      actions: /*#__PURE__*/(0, _react.css)(".euiBasicTableAction-showOnHover{opacity:0;", _global_styling.euiCanAnimate, "{transition:opacity ", euiTheme.animation.normal, " ", euiTheme.animation.resistance, ";}}&:focus-within,.euiTableRow-hasActions:hover &{.euiBasicTableAction-showOnHover{opacity:1;}};label:actions;")
    },
    mobile: {
      mobile: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-width', '50%'), ";;label:mobile;"),
      enlarge: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'm'), ";;label:enlarge;"),
      rightColumnContent: "\n        position: absolute;\n        ".concat((0, _global_styling.logicalCSS)('right', 0), "\n        ").concat((0, _global_styling.logicalCSS)('min-width', '0'), "\n        ").concat((0, _global_styling.logicalCSS)('width', mobileSizes.actions.width), "\n      "),
      get actions() {
        // Note: Visible-on-hover actions on desktop always show on mobile
        return /*#__PURE__*/(0, _react.css)(this.rightColumnContent, " ", (0, _global_styling.logicalCSS)('top', mobileSizes.actions.offset), ";;label:actions;");
      },
      get expander() {
        return /*#__PURE__*/(0, _react.css)(this.rightColumnContent, " ", (0, _global_styling.logicalCSS)('bottom', mobileSizes.actions.offset), ";;label:expander;");
      },
      /**
       * Custom actions may not be icons and therefore may not fit in a column
       * If they're the last cell, we can create a pseudo "row"/"border-top"
       * that mimicks the visual separation that the right column has
       */
      customActions: /*#__PURE__*/(0, _react.css)("&:last-child{", (0, _global_styling.logicalCSS)('width', '100%'), " &::before{content:'';position:absolute;", (0, _global_styling.logicalCSS)('horizontal', 0), " ", (0, _global_styling.logicalCSS)('height', euiTheme.border.width.thin), " background-color:", euiTheme.border.color, ";}.euiTableCellContent{position:relative;", (0, _global_styling.logicalCSS)('top', euiTheme.size.xs), ";}};label:customActions;")
    },
    euiTableRowCell__mobileHeader: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)(), " font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 's', {
      customScale: 'xxs'
    }).fontSize, ";display:block;color:", euiTheme.colors.darkShade, ";padding:", euiTheme.size.s, ";padding-block-end:0;margin-block-end:-", euiTheme.size.s, ";.euiTableRowCell:not(:only-child) &{", (0, _global_styling.logicalCSS)('min-height', euiTheme.size.l), ";};label:euiTableRowCell__mobileHeader;")
  };
};