"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableRowCellCheckbox = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _responsive_context = require("./mobile/responsive_context");
var _table_cells_shared = require("./table_cells_shared.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "append"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiTableRowCellCheckbox = exports.EuiTableRowCellCheckbox = function EuiTableRowCellCheckbox(_ref) {
  var children = _ref.children,
    className = _ref.className,
    append = _ref.append,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var isResponsive = (0, _responsive_context.useEuiTableIsResponsive)();
  var styles = (0, _services.useEuiMemoizedStyles)(_table_cells_shared.euiTableCellCheckboxStyles);
  var cssStyles = [styles.euiTableRowCellCheckbox, isResponsive ? styles.mobile : styles.desktop];
  var classes = (0, _classnames.default)('euiTableRowCellCheckbox', className);
  return (0, _react2.jsx)("td", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest), (0, _react2.jsx)("div", {
    className: "euiTableCellContent"
  }, children), append);
};